/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.DefaultKubernetesResourceList;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class KubernetesResourceUtil {
    public static final Pattern KUBERNETES_SUBDOMAIN_REGEX = Pattern.compile("[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*");
    public static final Pattern KUBERNETES_DNS1123_LABEL_REGEX = Pattern.compile("[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])?");
    public static final Pattern KUBERNETES_KEY_REGEX = Pattern.compile("(" + KUBERNETES_SUBDOMAIN_REGEX.toString() + "/)?[a-z0-9]([-_.a-z0-9]{0,61}[a-z0-9])?");
    private static final Pattern INVALID_LABEL_CHARS_PATTERN = Pattern.compile("[^-A-Za-z0-9]+");
    private static final String DEFAULT_CONTAINER_IMAGE_REGISTRY_SECRET_NAME = "container-image-registry-secret";

    private KubernetesResourceUtil() {
    }

    public static String getResourceVersion(HasMetadata entity) {
        String resourceVersion;
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null && !Utils.isNullOrEmpty(resourceVersion = metadata.getResourceVersion())) {
            return resourceVersion;
        }
        return null;
    }

    public static void setResourceVersion(HasMetadata entity, String resourceVersion) {
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null) {
            metadata.setResourceVersion(resourceVersion);
        }
    }

    public static void setNamespace(HasMetadata entity, String namespace) {
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null) {
            metadata.setNamespace(namespace);
        }
    }

    public static String getKind(HasMetadata entity) {
        if (entity != null) {
            if (entity instanceof KubernetesList) {
                return "List";
            }
            return entity.getClass().getSimpleName();
        }
        return null;
    }

    public static String getQualifiedName(HasMetadata entity) {
        if (entity != null) {
            return KubernetesResourceUtil.getNamespace(entity) + "/" + KubernetesResourceUtil.getName(entity);
        }
        return null;
    }

    public static String getName(HasMetadata entity) {
        if (entity != null) {
            return KubernetesResourceUtil.getName(entity.getMetadata());
        }
        return null;
    }

    public static boolean hasResourceVersion(HasMetadata entity) {
        return KubernetesResourceUtil.getResourceVersion(entity) != null;
    }

    public static String getName(ObjectMeta entity) {
        if (entity != null) {
            return Utils.coalesce(entity.getName(), KubernetesResourceUtil.getAdditionalPropertyText(entity.getAdditionalProperties(), "id"), entity.getUid());
        }
        return null;
    }

    protected static String getAdditionalPropertyText(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public static String getNamespace(ObjectMeta entity) {
        if (entity != null) {
            return entity.getNamespace();
        }
        return null;
    }

    public static String getNamespace(HasMetadata entity) {
        if (entity != null) {
            return KubernetesResourceUtil.getNamespace(entity.getMetadata());
        }
        return null;
    }

    public static Map<String, String> getOrCreateAnnotations(HasMetadata entity) {
        ObjectMeta metadata = KubernetesResourceUtil.getOrCreateMetadata(entity);
        Map<String, String> answer = metadata.getAnnotations();
        if (answer == null) {
            answer = new LinkedHashMap<String, String>();
            metadata.setAnnotations(answer);
        }
        return answer;
    }

    public static String sanitizeName(String name) {
        if (name != null) {
            int lastChar;
            if (!Character.isLetterOrDigit(((String)(name = INVALID_LABEL_CHARS_PATTERN.matcher((CharSequence)name).replaceAll("-"))).charAt(0))) {
                name = "a" + (String)name;
            }
            if (((String)name).length() > 63) {
                name = ((String)name).substring(0, 63);
            }
            if (!Character.isLetterOrDigit(((String)(name = ((String)name).toLowerCase())).charAt(lastChar = ((String)name).length() - 1))) {
                name = ((String)name).substring(0, lastChar - 1) + "a";
            }
            return name;
        }
        return null;
    }

    public static Map<String, String> getOrCreateLabels(HasMetadata entity) {
        ObjectMeta metadata = KubernetesResourceUtil.getOrCreateMetadata(entity);
        Map<String, String> answer = metadata.getLabels();
        if (answer == null) {
            answer = new LinkedHashMap<String, String>();
            metadata.setLabels(answer);
        }
        return answer;
    }

    public static Map<String, String> getLabels(ObjectMeta metadata) {
        Map<String, String> labels;
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            return labels;
        }
        return Collections.emptyMap();
    }

    public static ObjectMeta getOrCreateMetadata(HasMetadata entity) {
        ObjectMeta metadata = entity.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            entity.setMetadata(metadata);
        }
        return metadata;
    }

    public static boolean isValidName(String name) {
        return Utils.isNotNullOrEmpty(name) && KUBERNETES_DNS1123_LABEL_REGEX.matcher(name).matches();
    }

    public static boolean isValidKey(String key) {
        return Utils.isNotNullOrEmpty(key) && key.length() < 254 && KUBERNETES_KEY_REGEX.matcher(key).matches();
    }

    public static boolean isValidSubdomainName(String name) {
        return Utils.isNotNullOrEmpty(name) && name.length() < 254 && KUBERNETES_SUBDOMAIN_REGEX.matcher(name).matches();
    }

    @Deprecated
    public static boolean isValidLabelOrAnnotation(Map<String, String> map) {
        return KubernetesResourceUtil.areLabelsValid(map);
    }

    public static boolean areLabelsValid(Map<String, String> map) {
        return map.entrySet().stream().allMatch(e -> KubernetesResourceUtil.isValidKey((String)e.getKey()) && KubernetesResourceUtil.isValidName((String)e.getValue()));
    }

    public static boolean areAnnotationsValid(Map<String, String> map) {
        return map.keySet().stream().allMatch(KubernetesResourceUtil::isValidKey);
    }

    public static boolean hasController(HasMetadata resource) {
        return KubernetesResourceUtil.getControllerUid(resource) != null;
    }

    public static OwnerReference getControllerUid(HasMetadata resource) {
        if (resource.getMetadata() != null) {
            List<OwnerReference> ownerReferenceList = resource.getMetadata().getOwnerReferences();
            for (OwnerReference ownerReference : ownerReferenceList) {
                if (!Boolean.TRUE.equals(ownerReference.getController())) continue;
                return ownerReference;
            }
        }
        return null;
    }

    public static void sortEventListBasedOnTimestamp(List<Event> eventList) {
        if (eventList != null) {
            eventList.sort(Comparator.comparing(Event::getLastTimestamp, Comparator.nullsFirst(Comparator.comparing(Instant::parse).reversed())));
        }
    }

    public static List<EnvVar> convertMapToEnvVarList(Map<String, String> envVarMap) {
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        for (Map.Entry<String, String> entry : envVarMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            envVars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(entry.getKey())).withValue(entry.getValue())).build());
        }
        return envVars;
    }

    @Deprecated
    public static boolean isResourceReady(HasMetadata item) {
        return Readiness.getInstance().isReady(item);
    }

    public static Duration getAge(HasMetadata kubernetesResource) {
        Instant instant = Instant.parse(kubernetesResource.getMetadata().getCreationTimestamp());
        return Duration.between(instant, Instant.now()).abs();
    }

    public static <T extends HasMetadata> Class<? extends KubernetesResourceList> inferListType(Class<T> type) {
        return KubernetesResourceUtil.loadRelated(type, "List", DefaultKubernetesResourceList.class);
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> Class<V> inferBuilderType(Class<T> type) {
        return KubernetesResourceUtil.loadRelated(type, "Builder", null);
    }

    private static Class<?> loadRelated(Class<?> type, String suffix, Class<?> defaultClass) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(type.getName() + suffix);
        }
        catch (ClassCastException | ClassNotFoundException | NullPointerException e) {
            try {
                return type.getClassLoader().loadClass(type.getName() + suffix);
            }
            catch (ClassCastException | ClassNotFoundException | NullPointerException ex) {
                return defaultClass;
            }
        }
    }

    public static Secret createDockerRegistrySecret(String dockerServer, String username, String password) {
        Map<String, Object> dockerConfigMap = KubernetesResourceUtil.createDockerRegistryConfigMap(dockerServer, username, password);
        String dockerConfigAsStr = Serialization.asJson(dockerConfigMap);
        return KubernetesResourceUtil.createDockerSecret(DEFAULT_CONTAINER_IMAGE_REGISTRY_SECRET_NAME, dockerConfigAsStr);
    }

    public static Secret createDockerRegistrySecret(String dockerServer, String username, String password, String secretName) {
        Map<String, Object> dockerConfigMap = KubernetesResourceUtil.createDockerRegistryConfigMap(dockerServer, username, password);
        String dockerConfigAsStr = Serialization.asJson(dockerConfigMap);
        return KubernetesResourceUtil.createDockerSecret(secretName, dockerConfigAsStr);
    }

    public static ConfigMap createConfigMapFromDirOrFiles(String name, Path ... dirOrFilePaths) throws IOException {
        ConfigMapBuilder configMapBuilder = new ConfigMapBuilder();
        ((ConfigMapFluent.MetadataNested)configMapBuilder.withNewMetadata().withName(name)).endMetadata();
        for (Path dirOrFilePath : dirOrFilePaths) {
            File file = dirOrFilePath.toFile();
            KubernetesResourceUtil.addEntriesFromDirOrFileToConfigMap(configMapBuilder, file.getName(), dirOrFilePath);
        }
        return configMapBuilder.build();
    }

    private static Map.Entry<String, String> createConfigMapEntry(String key, Path file) throws IOException {
        byte[] bytes = Files.readAllBytes(file);
        if (KubernetesResourceUtil.isFileWithBinaryContent(file)) {
            String value = Base64.getEncoder().encodeToString(bytes);
            return new AbstractMap.SimpleEntry<String, String>(key, value);
        }
        return new AbstractMap.SimpleEntry<String, String>(key, new String(bytes));
    }

    private static boolean isFileWithBinaryContent(Path file) throws IOException {
        byte[] bytes = Files.readAllBytes(file);
        try {
            StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(bytes));
            return false;
        }
        catch (CharacterCodingException e) {
            return true;
        }
    }

    private static void addEntriesFromDirectoryToConfigMap(ConfigMapBuilder configMapBuilder, Path path) throws IOException {
        try (Stream<Path> files = Files.list(path);){
            files.filter(p -> !Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)).forEach(file -> {
                try {
                    KubernetesResourceUtil.addEntryToConfigMap(configMapBuilder, KubernetesResourceUtil.createConfigMapEntry(file.getFileName().toString(), file), file);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }
    }

    private static void addEntryFromFileToConfigMap(ConfigMapBuilder configMapBuilder, String key, Path file) throws IOException {
        String entryKey = Optional.ofNullable(key).orElse(file.toFile().getName());
        Map.Entry<String, String> configMapEntry = KubernetesResourceUtil.createConfigMapEntry(entryKey, file);
        KubernetesResourceUtil.addEntryToConfigMap(configMapBuilder, configMapEntry, file);
    }

    private static void addEntryToConfigMap(ConfigMapBuilder configMapBuilder, Map.Entry<String, String> entry, Path file) throws IOException {
        if (KubernetesResourceUtil.isFileWithBinaryContent(file)) {
            configMapBuilder.addToBinaryData(entry.getKey(), entry.getValue());
        } else {
            configMapBuilder.addToData(entry.getKey(), entry.getValue());
        }
    }

    public static ConfigMapBuilder addEntriesFromDirOrFileToConfigMap(ConfigMapBuilder configMapBuilder, String key, Path dirOrFilePath) throws IOException {
        if (!Files.exists(dirOrFilePath, new LinkOption[0])) {
            throw new IllegalArgumentException("invalid file path provided " + String.valueOf(dirOrFilePath));
        }
        if (Files.isDirectory(dirOrFilePath, LinkOption.NOFOLLOW_LINKS)) {
            KubernetesResourceUtil.addEntriesFromDirectoryToConfigMap(configMapBuilder, dirOrFilePath);
        } else {
            KubernetesResourceUtil.addEntryFromFileToConfigMap(configMapBuilder, key, dirOrFilePath);
        }
        return configMapBuilder;
    }

    private static Map<String, Object> createDockerRegistryConfigMap(String dockerServer, String username, String password) {
        HashMap<String, Object> dockerConfigMap = new HashMap<String, Object>();
        HashMap auths = new HashMap();
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", username);
        credentials.put("password", password);
        String usernameAndPasswordAuth = username + ":" + password;
        credentials.put("auth", Base64.getEncoder().encodeToString(usernameAndPasswordAuth.getBytes(StandardCharsets.UTF_8)));
        auths.put(dockerServer, credentials);
        dockerConfigMap.put("auths", auths);
        return dockerConfigMap;
    }

    private static Secret createDockerSecret(String secretName, String dockerConfig) {
        return ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(secretName)).endMetadata()).withType("kubernetes.io/dockerconfigjson")).addToData(".dockerconfigjson", Base64.getEncoder().encodeToString(dockerConfig.getBytes(StandardCharsets.UTF_8)))).build();
    }
}

