/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.HostAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HostAliasFluent<A extends HostAliasFluent<A>>
extends BaseFluent<A> {
    private List<String> hostnames = new ArrayList<String>();
    private String ip;
    private Map<String, Object> additionalProperties;

    public HostAliasFluent() {
    }

    public HostAliasFluent(HostAlias instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HostAlias instance) {
        HostAlias hostAlias = instance = instance != null ? instance : new HostAlias();
        if (instance != null) {
            this.withHostnames(instance.getHostnames());
            this.withIp(instance.getIp());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(index, item);
        return (A)this;
    }

    public A setToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.set(index, item);
        return (A)this;
    }

    public A addToHostnames(String ... items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    public A addAllToHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    public A removeFromHostnames(String ... items) {
        if (this.hostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    public List<String> getHostnames() {
        return this.hostnames;
    }

    public String getHostname(int index) {
        return this.hostnames.get(index);
    }

    public String getFirstHostname() {
        return this.hostnames.get(0);
    }

    public String getLastHostname() {
        return this.hostnames.get(this.hostnames.size() - 1);
    }

    public String getMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostnames(List<String> hostnames) {
        if (hostnames != null) {
            this.hostnames = new ArrayList<String>();
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        } else {
            this.hostnames = null;
        }
        return (A)this;
    }

    public A withHostnames(String ... hostnames) {
        if (this.hostnames != null) {
            this.hostnames.clear();
            this._visitables.remove("hostnames");
        }
        if (hostnames != null) {
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        }
        return (A)this;
    }

    public boolean hasHostnames() {
        return this.hostnames != null && !this.hostnames.isEmpty();
    }

    public String getIp() {
        return this.ip;
    }

    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    public boolean hasIp() {
        return this.ip != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostAliasFluent that = (HostAliasFluent)o;
        if (!Objects.equals(this.hostnames, that.hostnames)) {
            return false;
        }
        if (!Objects.equals(this.ip, that.ip)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostnames, this.ip, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostnames != null && !this.hostnames.isEmpty()) {
            sb.append("hostnames:");
            sb.append(String.valueOf(this.hostnames) + ",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

