/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.resource.v1beta2.AllocatedDeviceStatus;
import io.fabric8.kubernetes.api.model.resource.v1beta2.AllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1beta2.ResourceClaimConsumerReference;
import io.fabric8.kubernetes.api.model.resource.v1beta2.ResourceClaimStatusBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"allocation", "devices", "reservedFor"})
public class ResourceClaimStatus
implements Editable<ResourceClaimStatusBuilder>,
KubernetesResource {
    @JsonProperty(value="allocation")
    private AllocationResult allocation;
    @JsonProperty(value="devices")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<AllocatedDeviceStatus> devices = new ArrayList<AllocatedDeviceStatus>();
    @JsonProperty(value="reservedFor")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ResourceClaimConsumerReference> reservedFor = new ArrayList<ResourceClaimConsumerReference>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public ResourceClaimStatus() {
    }

    public ResourceClaimStatus(AllocationResult allocation, List<AllocatedDeviceStatus> devices, List<ResourceClaimConsumerReference> reservedFor) {
        this.allocation = allocation;
        this.devices = devices;
        this.reservedFor = reservedFor;
    }

    @JsonProperty(value="allocation")
    public AllocationResult getAllocation() {
        return this.allocation;
    }

    @JsonProperty(value="allocation")
    public void setAllocation(AllocationResult allocation) {
        this.allocation = allocation;
    }

    @JsonProperty(value="devices")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<AllocatedDeviceStatus> getDevices() {
        return this.devices;
    }

    @JsonProperty(value="devices")
    public void setDevices(List<AllocatedDeviceStatus> devices) {
        this.devices = devices;
    }

    @JsonProperty(value="reservedFor")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ResourceClaimConsumerReference> getReservedFor() {
        return this.reservedFor;
    }

    @JsonProperty(value="reservedFor")
    public void setReservedFor(List<ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
    }

    @Override
    @JsonIgnore
    public ResourceClaimStatusBuilder edit() {
        return new ResourceClaimStatusBuilder(this);
    }

    @JsonIgnore
    public ResourceClaimStatusBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public String toString() {
        return "ResourceClaimStatus(allocation=" + String.valueOf(this.getAllocation()) + ", devices=" + String.valueOf(this.getDevices()) + ", reservedFor=" + String.valueOf(this.getReservedFor()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceClaimStatus)) {
            return false;
        }
        ResourceClaimStatus other = (ResourceClaimStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AllocationResult this$allocation = this.getAllocation();
        AllocationResult other$allocation = other.getAllocation();
        if (this$allocation == null ? other$allocation != null : !((Object)this$allocation).equals(other$allocation)) {
            return false;
        }
        List<AllocatedDeviceStatus> this$devices = this.getDevices();
        List<AllocatedDeviceStatus> other$devices = other.getDevices();
        if (this$devices == null ? other$devices != null : !((Object)this$devices).equals(other$devices)) {
            return false;
        }
        List<ResourceClaimConsumerReference> this$reservedFor = this.getReservedFor();
        List<ResourceClaimConsumerReference> other$reservedFor = other.getReservedFor();
        if (this$reservedFor == null ? other$reservedFor != null : !((Object)this$reservedFor).equals(other$reservedFor)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResourceClaimStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AllocationResult $allocation = this.getAllocation();
        result = result * 59 + ($allocation == null ? 43 : ((Object)$allocation).hashCode());
        List<AllocatedDeviceStatus> $devices = this.getDevices();
        result = result * 59 + ($devices == null ? 43 : ((Object)$devices).hashCode());
        List<ResourceClaimConsumerReference> $reservedFor = this.getReservedFor();
        result = result * 59 + ($reservedFor == null ? 43 : ((Object)$reservedFor).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

