/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.collector;

import io.fabric8.crd.generator.collector.JandexException;
import io.fabric8.crd.generator.collector.JandexUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class JandexCustomResourceClassScanner {
    private final List<IndexView> indices = new LinkedList<IndexView>();
    private final Set<File> filesToScan = new HashSet<File>();
    private boolean forceIndex = false;

    public JandexCustomResourceClassScanner withForceIndex(boolean forceIndex) {
        this.forceIndex = forceIndex;
        return this;
    }

    public JandexCustomResourceClassScanner withIndex(IndexView ... index) {
        if (index != null) {
            this.withIndices(Arrays.asList(index));
        }
        return this;
    }

    public JandexCustomResourceClassScanner withIndices(Collection<IndexView> indices) {
        if (indices != null) {
            indices.stream().filter(Objects::nonNull).forEach(this.indices::add);
        }
        return this;
    }

    public JandexCustomResourceClassScanner withFileToScan(File ... files) {
        if (files != null) {
            this.withFilesToScan(Arrays.asList(files));
        }
        return this;
    }

    public JandexCustomResourceClassScanner withFilesToScan(Collection<File> files) {
        if (files != null) {
            files.stream().filter(Objects::nonNull).forEach(this.filesToScan::add);
        }
        return this;
    }

    public Collection<String> findCustomResourceClasses() {
        ArrayList<IndexView> actualIndices = new ArrayList<IndexView>(this.indices);
        actualIndices.add(this.createBaseIndex());
        IndexView index = JandexUtils.createIndex(actualIndices, this.filesToScan, this.forceIndex);
        return this.findCustomResourceClasses(index).stream().map(ClassInfo::toString).collect(Collectors.toList());
    }

    private List<ClassInfo> findCustomResourceClasses(IndexView index) {
        return index.getAllKnownImplementors(HasMetadata.class).stream().filter(classInfo -> classInfo.hasAnnotation(Group.class)).filter(classInfo -> classInfo.hasAnnotation(Version.class)).collect(Collectors.toList());
    }

    private Index createBaseIndex() {
        try {
            Indexer indexer = new Indexer();
            indexer.indexClass(HasMetadata.class);
            indexer.indexClass(CustomResource.class);
            return indexer.complete();
        }
        catch (IOException e) {
            throw new JandexException("Could not create base index", e);
        }
    }

    void reset() {
        this.indices.clear();
        this.filesToScan.clear();
        this.forceIndex = false;
    }
}

