/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.v1beta1.decorator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddCustomResourceDefinitionResourceDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddCustomResourceDefinitionVersionDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddLabelSelectorPathDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddSchemaToCustomResourceDefinitionVersionDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddSpecReplicasPathDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddStatusReplicasPathDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddStatusSubresourceDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddSubresourcesDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.CustomResourceDefinitionDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.CustomResourceDefinitionVersionDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PromoteSingleVersionAttributesDecorator
extends CustomResourceDefinitionDecorator<CustomResourceDefinitionSpecFluent<?>> {
    public PromoteSingleVersionAttributesDecorator(String name) {
        super(name);
    }

    private CustomResourceSubresources mergeSubresources(CustomResourceSubresources versionSub, CustomResourceSubresources topLevelSub) {
        if (versionSub == null) {
            return topLevelSub;
        }
        if (topLevelSub == null) {
            return versionSub;
        }
        HashMap additionalProperties = new HashMap();
        if (versionSub.getAdditionalProperties() != null) {
            additionalProperties.putAll(versionSub.getAdditionalProperties());
        }
        if (topLevelSub.getAdditionalProperties() != null) {
            additionalProperties.putAll(topLevelSub.getAdditionalProperties());
        }
        CustomResourceSubresourceScale scale = null;
        if (topLevelSub.getScale() != null) {
            scale = topLevelSub.getScale();
        } else if (versionSub.getScale() != null) {
            scale = versionSub.getScale();
        }
        CustomResourceSubresourceStatus status = null;
        if (topLevelSub.getStatus() != null) {
            status = topLevelSub.getStatus();
        } else if (versionSub.getStatus() != null) {
            status = versionSub.getStatus();
        }
        return ((CustomResourceSubresourcesBuilder)((CustomResourceSubresourcesBuilder)((CustomResourceSubresourcesBuilder)new CustomResourceSubresourcesBuilder().withAdditionalProperties(additionalProperties)).withScale(scale)).withStatus(status)).build();
    }

    @Override
    public void andThenVisit(CustomResourceDefinitionSpecFluent<?> spec, ObjectMeta resourceMeta) {
        List versions = spec.buildVersions();
        if (versions.size() == 1) {
            CustomResourceDefinitionVersion version = (CustomResourceDefinitionVersion)versions.get(0);
            spec.withSubresources(this.mergeSubresources(version.getSubresources(), spec.buildSubresources())).withValidation(version.getSchema()).withAdditionalPrinterColumns(version.getAdditionalPrinterColumns());
            CustomResourceDefinitionVersion newVersion = new CustomResourceDefinitionVersionBuilder(version).build();
            newVersion.setSubresources(null);
            newVersion.setSchema(null);
            newVersion.setAdditionalPrinterColumns(null);
            spec.removeAllFromVersions((Collection)versions);
            spec.withVersions(new CustomResourceDefinitionVersion[]{newVersion});
        } else {
            boolean hasIdenticalSchemas;
            Set subresources = versions.stream().map(CustomResourceDefinitionVersion::getSubresources).filter(o -> o != null).collect(Collectors.toSet());
            Set additionalPrinterColumns = versions.stream().map(CustomResourceDefinitionVersion::getAdditionalPrinterColumns).filter(o -> o != null).collect(Collectors.toSet());
            Set schemas = versions.stream().map(CustomResourceDefinitionVersion::getSchema).filter(o -> o != null).collect(Collectors.toSet());
            boolean hasIdenticalSubresources = subresources.size() == 1;
            boolean hasIdenticalAdditionalPrinterColumns = additionalPrinterColumns.size() == 1;
            boolean bl = hasIdenticalSchemas = schemas.size() == 1;
            if (hasIdenticalSchemas) {
                spec.withValidation((CustomResourceValidation)schemas.iterator().next());
            }
            if (hasIdenticalSubresources) {
                spec.withSubresources(this.mergeSubresources((CustomResourceSubresources)subresources.iterator().next(), spec.buildSubresources()));
            }
            if (hasIdenticalAdditionalPrinterColumns) {
                spec.withAdditionalPrinterColumns((List)additionalPrinterColumns.iterator().next());
            }
            spec.removeAllFromVersions((Collection)versions);
            ArrayList<CustomResourceDefinitionVersion> newVersions = new ArrayList<CustomResourceDefinitionVersion>();
            for (CustomResourceDefinitionVersion version : versions) {
                CustomResourceDefinitionVersion newVersion = new CustomResourceDefinitionVersionBuilder(version).build();
                if (hasIdenticalSchemas) {
                    newVersion.setSchema(null);
                }
                if (hasIdenticalSubresources) {
                    newVersion.setSubresources(null);
                }
                if (hasIdenticalAdditionalPrinterColumns) {
                    newVersion.setAdditionalPrinterColumns(null);
                }
                newVersions.add(newVersion);
            }
            spec.withVersions(newVersions);
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{AddCustomResourceDefinitionResourceDecorator.class, AddCustomResourceDefinitionVersionDecorator.class, CustomResourceDefinitionVersionDecorator.class, AddSchemaToCustomResourceDefinitionVersionDecorator.class, AddSubresourcesDecorator.class, AddStatusSubresourceDecorator.class, AddStatusReplicasPathDecorator.class, AddSpecReplicasPathDecorator.class, AddLabelSelectorPathDecorator.class};
    }
}

