/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Resources {
    private final KubernetesListBuilder global = new KubernetesListBuilder();
    private final Set<Decorator> globalDecorators = new HashSet<Decorator>();

    public KubernetesListBuilder global() {
        return this.global;
    }

    public void decorate(Decorator decorator) {
        this.globalDecorators.add(decorator);
    }

    public void add(HasMetadata metadata) {
        this.global.addToItems(new HasMetadata[]{metadata});
    }

    public KubernetesList generate() {
        for (Decorator decorator : this.applyConstraints(this.globalDecorators)) {
            this.global.accept(new Visitor[]{decorator});
        }
        return this.global.build();
    }

    public List<Decorator> applyConstraints(Set<Decorator> decorators) {
        ArrayList<Decorator> result = new ArrayList<Decorator>();
        Decorator[] array = decorators.toArray(new Decorator[decorators.size()]);
        this.bubbleSort(array);
        for (Decorator d : array) {
            result.add(d);
        }
        return result;
    }

    private void bubbleSort(Decorator[] decorators) {
        int n = decorators.length;
        Decorator temp = null;
        for (int i = 0; i < n; ++i) {
            for (int j = 1; j < n - i; ++j) {
                if (decorators[j].compareTo(decorators[j - 1]) >= 0) continue;
                temp = decorators[j - 1];
                decorators[j - 1] = decorators[j];
                decorators[j] = temp;
            }
        }
    }
}

