/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.decorator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.decorator.ResourceProvidingDecorator;
import io.fabric8.crd.generator.utils.Generics;
import io.fabric8.crd.generator.utils.Metadata;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Optional;

public abstract class NamedResourceDecorator<T>
extends Decorator<VisitableBuilder> {
    public static final String ANY = null;
    protected final String kind;
    protected final String name;
    private final ResourceVisitor visitor = new ResourceVisitor(null, null);

    public NamedResourceDecorator() {
        this(ANY, ANY);
    }

    public NamedResourceDecorator(String name) {
        this(ANY, name);
    }

    public NamedResourceDecorator(String kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public void visit(VisitableBuilder builder) {
        Optional<String> resourceKind = Metadata.getKind((Builder)builder);
        Optional<ObjectMeta> objectMeta = Metadata.getMetadata((Builder)builder);
        if (!resourceKind.isPresent() || !objectMeta.isPresent()) {
            return;
        }
        if (Utils.isNullOrEmpty((String)this.kind)) {
            if (Utils.isNullOrEmpty((String)this.name)) {
                builder.accept(new Visitor[]{this.visitor.withKind(resourceKind.get()).withMetadata(objectMeta.get())});
            } else if (objectMeta.map(ObjectMeta::getName).filter(s -> s.equals(this.name)).isPresent()) {
                builder.accept(new Visitor[]{this.visitor.withKind(resourceKind.get()).withMetadata(objectMeta.get())});
            }
        } else if (resourceKind.filter(k -> k.equals(this.kind)).isPresent()) {
            if (Utils.isNullOrEmpty((String)this.name)) {
                builder.accept(new Visitor[]{this.visitor.withKind(resourceKind.get()).withMetadata(objectMeta.get())});
            } else if (objectMeta.map(ObjectMeta::getName).filter(s -> s.equals(this.name)).isPresent()) {
                builder.accept(new Visitor[]{this.visitor.withKind(resourceKind.get()).withMetadata(objectMeta.get())});
            }
        }
    }

    public abstract void andThenVisit(T var1, ObjectMeta var2);

    public void andThenVisit(T item, String kind, ObjectMeta resourceMeta) {
        this.andThenVisit(item, resourceMeta);
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }

    private class ResourceVisitor
    extends TypedVisitor<T> {
        private final String kind;
        private final ObjectMeta metadata;

        public ResourceVisitor(String kind, ObjectMeta metadata) {
            this.kind = kind;
            this.metadata = metadata;
        }

        public void visit(T item) {
            NamedResourceDecorator.this.andThenVisit(item, this.kind, this.metadata);
        }

        public ResourceVisitor withKind(String kind) {
            return new ResourceVisitor(kind, this.metadata);
        }

        public ResourceVisitor withMetadata(ObjectMeta metadata) {
            return new ResourceVisitor(this.kind, metadata);
        }

        public Class<T> getType() {
            return Generics.getTypeArguments(NamedResourceDecorator.class, NamedResourceDecorator.this.getClass()).get(0);
        }
    }
}

