/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaFactory;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.fabric8.kubernetes.client.utils.YamlDumpSettings;
import io.fabric8.kubernetes.client.utils.YamlDumpSettingsBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResolvingContext {
    final JsonSchemaGenerator generator;
    final ObjectMapper objectMapper;
    final KubernetesSerialization kubernetesSerialization;
    final Map<String, GeneratorObjectSchema> uriToJacksonSchema;
    final boolean implicitPreserveUnknownFields;
    private static ObjectMapper OBJECT_MAPPER;

    public static ResolvingContext defaultResolvingContext(boolean implicitPreserveUnknownFields) {
        return ResolvingContext.defaultResolvingContext(implicitPreserveUnknownFields, new YamlDumpSettingsBuilder().build());
    }

    public static ResolvingContext defaultResolvingContext(boolean implicitPreserveUnknownFields, YamlDumpSettings yamlDumpSettings) {
        if (OBJECT_MAPPER == null) {
            OBJECT_MAPPER = new ObjectMapper();
        }
        return new ResolvingContext(OBJECT_MAPPER, new KubernetesSerialization(OBJECT_MAPPER, false, yamlDumpSettings), implicitPreserveUnknownFields);
    }

    public ResolvingContext forkContext() {
        return new ResolvingContext(this.objectMapper, this.kubernetesSerialization, this.uriToJacksonSchema, this.implicitPreserveUnknownFields);
    }

    public ResolvingContext(ObjectMapper mapper, KubernetesSerialization kubernetesSerialization, boolean implicitPreserveUnknownFields) {
        this(mapper, kubernetesSerialization, new ConcurrentHashMap<String, GeneratorObjectSchema>(), implicitPreserveUnknownFields);
    }

    private ResolvingContext(ObjectMapper mapper, KubernetesSerialization kubernetesSerialization, Map<String, GeneratorObjectSchema> uriToJacksonSchema, boolean implicitPreserveUnknownFields) {
        this.uriToJacksonSchema = uriToJacksonSchema;
        this.objectMapper = mapper;
        this.kubernetesSerialization = kubernetesSerialization;
        this.implicitPreserveUnknownFields = implicitPreserveUnknownFields;
        this.generator = new JsonSchemaGenerator(mapper, new WrapperFactory(){

            public SchemaFactoryWrapper getWrapper(SerializerProvider provider) {
                return new KubernetesSchemaFactoryWrapper(provider, this);
            }

            public SchemaFactoryWrapper getWrapper(SerializerProvider provider, VisitorContext rvc) {
                SchemaFactoryWrapper wrapper = this.getWrapper(provider);
                wrapper.setVisitorContext(rvc);
                return wrapper;
            }
        });
    }

    JsonSchema toJsonSchema(Class<?> clazz) {
        try {
            return this.generator.generateSchema(clazz);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private final class KubernetesSchemaFactoryWrapper
    extends SchemaFactoryWrapper {
        private KubernetesSchemaFactoryWrapper(SerializerProvider p, WrapperFactory wrapperFactory) {
            super(p, wrapperFactory);
            this.schemaProvider = new JsonSchemaFactory(){

                public ObjectSchema objectSchema() {
                    return new GeneratorObjectSchema();
                }
            };
        }

        public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
            JsonObjectFormatVisitor result = super.expectObjectFormat(convertedType);
            ((GeneratorObjectSchema)this.schema).javaType = convertedType;
            ResolvingContext.this.uriToJacksonSchema.putIfAbsent(this.visitorContext.getSeenSchemaUri(convertedType), (GeneratorObjectSchema)this.schema);
            return result;
        }
    }

    static final class GeneratorObjectSchema
    extends ObjectSchema {
        JavaType javaType;
        Map<String, BeanProperty> beanProperties = new LinkedHashMap<String, BeanProperty>();

        GeneratorObjectSchema() {
        }

        public void putOptionalProperty(BeanProperty property, JsonSchema jsonSchema) {
            this.beanProperties.put(property.getName(), property);
            super.putOptionalProperty(property, jsonSchema);
        }

        public JsonSchema putProperty(BeanProperty property, JsonSchema value) {
            this.beanProperties.put(property.getName(), property);
            return super.putProperty(property, value);
        }
    }
}

