package io.fabric8.certmanager.api.model.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NameConstraintsFluent<A extends NameConstraintsFluent<A>> extends BaseFluent<A>{
  public NameConstraintsFluent() {
  }
  
  public NameConstraintsFluent(NameConstraints instance) {
    this.copyInstance(instance);
  }
  private Boolean critical;
  private NameConstraintItemBuilder excluded;
  private NameConstraintItemBuilder permitted;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NameConstraints instance) {
    instance = (instance != null ? instance : new NameConstraints());
    if (instance != null) {
          this.withCritical(instance.getCritical());
          this.withExcluded(instance.getExcluded());
          this.withPermitted(instance.getPermitted());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getCritical() {
    return this.critical;
  }
  
  public A withCritical(Boolean critical) {
    this.critical = critical;
    return (A) this;
  }
  
  public boolean hasCritical() {
    return this.critical != null;
  }
  
  public NameConstraintItem buildExcluded() {
    return this.excluded != null ? this.excluded.build() : null;
  }
  
  public A withExcluded(NameConstraintItem excluded) {
    this._visitables.remove("excluded");
    if (excluded != null) {
        this.excluded = new NameConstraintItemBuilder(excluded);
        this._visitables.get("excluded").add(this.excluded);
    } else {
        this.excluded = null;
        this._visitables.get("excluded").remove(this.excluded);
    }
    return (A) this;
  }
  
  public boolean hasExcluded() {
    return this.excluded != null;
  }
  
  public ExcludedNested<A> withNewExcluded() {
    return new ExcludedNested(null);
  }
  
  public ExcludedNested<A> withNewExcludedLike(NameConstraintItem item) {
    return new ExcludedNested(item);
  }
  
  public ExcludedNested<A> editExcluded() {
    return withNewExcludedLike(java.util.Optional.ofNullable(buildExcluded()).orElse(null));
  }
  
  public ExcludedNested<A> editOrNewExcluded() {
    return withNewExcludedLike(java.util.Optional.ofNullable(buildExcluded()).orElse(new NameConstraintItemBuilder().build()));
  }
  
  public ExcludedNested<A> editOrNewExcludedLike(NameConstraintItem item) {
    return withNewExcludedLike(java.util.Optional.ofNullable(buildExcluded()).orElse(item));
  }
  
  public NameConstraintItem buildPermitted() {
    return this.permitted != null ? this.permitted.build() : null;
  }
  
  public A withPermitted(NameConstraintItem permitted) {
    this._visitables.remove("permitted");
    if (permitted != null) {
        this.permitted = new NameConstraintItemBuilder(permitted);
        this._visitables.get("permitted").add(this.permitted);
    } else {
        this.permitted = null;
        this._visitables.get("permitted").remove(this.permitted);
    }
    return (A) this;
  }
  
  public boolean hasPermitted() {
    return this.permitted != null;
  }
  
  public PermittedNested<A> withNewPermitted() {
    return new PermittedNested(null);
  }
  
  public PermittedNested<A> withNewPermittedLike(NameConstraintItem item) {
    return new PermittedNested(item);
  }
  
  public PermittedNested<A> editPermitted() {
    return withNewPermittedLike(java.util.Optional.ofNullable(buildPermitted()).orElse(null));
  }
  
  public PermittedNested<A> editOrNewPermitted() {
    return withNewPermittedLike(java.util.Optional.ofNullable(buildPermitted()).orElse(new NameConstraintItemBuilder().build()));
  }
  
  public PermittedNested<A> editOrNewPermittedLike(NameConstraintItem item) {
    return withNewPermittedLike(java.util.Optional.ofNullable(buildPermitted()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NameConstraintsFluent that = (NameConstraintsFluent) o;
    if (!java.util.Objects.equals(critical, that.critical)) return false;
    if (!java.util.Objects.equals(excluded, that.excluded)) return false;
    if (!java.util.Objects.equals(permitted, that.permitted)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(critical,  excluded,  permitted,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (critical != null) { sb.append("critical:"); sb.append(critical + ","); }
    if (excluded != null) { sb.append("excluded:"); sb.append(excluded + ","); }
    if (permitted != null) { sb.append("permitted:"); sb.append(permitted + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withCritical() {
    return withCritical(true);
  }
  public class ExcludedNested<N> extends NameConstraintItemFluent<ExcludedNested<N>> implements Nested<N>{
    ExcludedNested(NameConstraintItem item) {
      this.builder = new NameConstraintItemBuilder(this, item);
    }
    NameConstraintItemBuilder builder;
    
    public N and() {
      return (N) NameConstraintsFluent.this.withExcluded(builder.build());
    }
    
    public N endExcluded() {
      return and();
    }
    
  
  }
  public class PermittedNested<N> extends NameConstraintItemFluent<PermittedNested<N>> implements Nested<N>{
    PermittedNested(NameConstraintItem item) {
      this.builder = new NameConstraintItemBuilder(this, item);
    }
    NameConstraintItemBuilder builder;
    
    public N and() {
      return (N) NameConstraintsFluent.this.withPermitted(builder.build());
    }
    
    public N endPermitted() {
      return and();
    }
    
  
  }

}