package io.fabric8.certmanager.api.model.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NameConstraintItemFluent<A extends NameConstraintItemFluent<A>> extends BaseFluent<A>{
  public NameConstraintItemFluent() {
  }
  
  public NameConstraintItemFluent(NameConstraintItem instance) {
    this.copyInstance(instance);
  }
  private List<String> dnsDomains = new ArrayList<String>();
  private List<String> emailAddresses = new ArrayList<String>();
  private List<String> ipRanges = new ArrayList<String>();
  private List<String> uriDomains = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NameConstraintItem instance) {
    instance = (instance != null ? instance : new NameConstraintItem());
    if (instance != null) {
          this.withDnsDomains(instance.getDnsDomains());
          this.withEmailAddresses(instance.getEmailAddresses());
          this.withIpRanges(instance.getIpRanges());
          this.withUriDomains(instance.getUriDomains());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToDnsDomains(int index,String item) {
    if (this.dnsDomains == null) {this.dnsDomains = new ArrayList<String>();}
    this.dnsDomains.add(index, item);
    return (A)this;
  }
  
  public A setToDnsDomains(int index,String item) {
    if (this.dnsDomains == null) {this.dnsDomains = new ArrayList<String>();}
    this.dnsDomains.set(index, item); return (A)this;
  }
  
  public A addToDnsDomains(java.lang.String... items) {
    if (this.dnsDomains == null) {this.dnsDomains = new ArrayList<String>();}
    for (String item : items) {this.dnsDomains.add(item);} return (A)this;
  }
  
  public A addAllToDnsDomains(Collection<String> items) {
    if (this.dnsDomains == null) {this.dnsDomains = new ArrayList<String>();}
    for (String item : items) {this.dnsDomains.add(item);} return (A)this;
  }
  
  public A removeFromDnsDomains(java.lang.String... items) {
    if (this.dnsDomains == null) return (A)this;
    for (String item : items) { this.dnsDomains.remove(item);} return (A)this;
  }
  
  public A removeAllFromDnsDomains(Collection<String> items) {
    if (this.dnsDomains == null) return (A)this;
    for (String item : items) { this.dnsDomains.remove(item);} return (A)this;
  }
  
  public List<String> getDnsDomains() {
    return this.dnsDomains;
  }
  
  public String getDnsDomain(int index) {
    return this.dnsDomains.get(index);
  }
  
  public String getFirstDnsDomain() {
    return this.dnsDomains.get(0);
  }
  
  public String getLastDnsDomain() {
    return this.dnsDomains.get(dnsDomains.size() - 1);
  }
  
  public String getMatchingDnsDomain(Predicate<String> predicate) {
      for (String item : dnsDomains) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingDnsDomain(Predicate<String> predicate) {
      for (String item : dnsDomains) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDnsDomains(List<String> dnsDomains) {
    if (dnsDomains != null) {
        this.dnsDomains = new ArrayList();
        for (String item : dnsDomains) {
          this.addToDnsDomains(item);
        }
    } else {
      this.dnsDomains = null;
    }
    return (A) this;
  }
  
  public A withDnsDomains(java.lang.String... dnsDomains) {
    if (this.dnsDomains != null) {
        this.dnsDomains.clear();
        _visitables.remove("dnsDomains");
    }
    if (dnsDomains != null) {
      for (String item : dnsDomains) {
        this.addToDnsDomains(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDnsDomains() {
    return this.dnsDomains != null && !this.dnsDomains.isEmpty();
  }
  
  public A addToEmailAddresses(int index,String item) {
    if (this.emailAddresses == null) {this.emailAddresses = new ArrayList<String>();}
    this.emailAddresses.add(index, item);
    return (A)this;
  }
  
  public A setToEmailAddresses(int index,String item) {
    if (this.emailAddresses == null) {this.emailAddresses = new ArrayList<String>();}
    this.emailAddresses.set(index, item); return (A)this;
  }
  
  public A addToEmailAddresses(java.lang.String... items) {
    if (this.emailAddresses == null) {this.emailAddresses = new ArrayList<String>();}
    for (String item : items) {this.emailAddresses.add(item);} return (A)this;
  }
  
  public A addAllToEmailAddresses(Collection<String> items) {
    if (this.emailAddresses == null) {this.emailAddresses = new ArrayList<String>();}
    for (String item : items) {this.emailAddresses.add(item);} return (A)this;
  }
  
  public A removeFromEmailAddresses(java.lang.String... items) {
    if (this.emailAddresses == null) return (A)this;
    for (String item : items) { this.emailAddresses.remove(item);} return (A)this;
  }
  
  public A removeAllFromEmailAddresses(Collection<String> items) {
    if (this.emailAddresses == null) return (A)this;
    for (String item : items) { this.emailAddresses.remove(item);} return (A)this;
  }
  
  public List<String> getEmailAddresses() {
    return this.emailAddresses;
  }
  
  public String getEmailAddress(int index) {
    return this.emailAddresses.get(index);
  }
  
  public String getFirstEmailAddress() {
    return this.emailAddresses.get(0);
  }
  
  public String getLastEmailAddress() {
    return this.emailAddresses.get(emailAddresses.size() - 1);
  }
  
  public String getMatchingEmailAddress(Predicate<String> predicate) {
      for (String item : emailAddresses) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingEmailAddress(Predicate<String> predicate) {
      for (String item : emailAddresses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEmailAddresses(List<String> emailAddresses) {
    if (emailAddresses != null) {
        this.emailAddresses = new ArrayList();
        for (String item : emailAddresses) {
          this.addToEmailAddresses(item);
        }
    } else {
      this.emailAddresses = null;
    }
    return (A) this;
  }
  
  public A withEmailAddresses(java.lang.String... emailAddresses) {
    if (this.emailAddresses != null) {
        this.emailAddresses.clear();
        _visitables.remove("emailAddresses");
    }
    if (emailAddresses != null) {
      for (String item : emailAddresses) {
        this.addToEmailAddresses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEmailAddresses() {
    return this.emailAddresses != null && !this.emailAddresses.isEmpty();
  }
  
  public A addToIpRanges(int index,String item) {
    if (this.ipRanges == null) {this.ipRanges = new ArrayList<String>();}
    this.ipRanges.add(index, item);
    return (A)this;
  }
  
  public A setToIpRanges(int index,String item) {
    if (this.ipRanges == null) {this.ipRanges = new ArrayList<String>();}
    this.ipRanges.set(index, item); return (A)this;
  }
  
  public A addToIpRanges(java.lang.String... items) {
    if (this.ipRanges == null) {this.ipRanges = new ArrayList<String>();}
    for (String item : items) {this.ipRanges.add(item);} return (A)this;
  }
  
  public A addAllToIpRanges(Collection<String> items) {
    if (this.ipRanges == null) {this.ipRanges = new ArrayList<String>();}
    for (String item : items) {this.ipRanges.add(item);} return (A)this;
  }
  
  public A removeFromIpRanges(java.lang.String... items) {
    if (this.ipRanges == null) return (A)this;
    for (String item : items) { this.ipRanges.remove(item);} return (A)this;
  }
  
  public A removeAllFromIpRanges(Collection<String> items) {
    if (this.ipRanges == null) return (A)this;
    for (String item : items) { this.ipRanges.remove(item);} return (A)this;
  }
  
  public List<String> getIpRanges() {
    return this.ipRanges;
  }
  
  public String getIpRange(int index) {
    return this.ipRanges.get(index);
  }
  
  public String getFirstIpRange() {
    return this.ipRanges.get(0);
  }
  
  public String getLastIpRange() {
    return this.ipRanges.get(ipRanges.size() - 1);
  }
  
  public String getMatchingIpRange(Predicate<String> predicate) {
      for (String item : ipRanges) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingIpRange(Predicate<String> predicate) {
      for (String item : ipRanges) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIpRanges(List<String> ipRanges) {
    if (ipRanges != null) {
        this.ipRanges = new ArrayList();
        for (String item : ipRanges) {
          this.addToIpRanges(item);
        }
    } else {
      this.ipRanges = null;
    }
    return (A) this;
  }
  
  public A withIpRanges(java.lang.String... ipRanges) {
    if (this.ipRanges != null) {
        this.ipRanges.clear();
        _visitables.remove("ipRanges");
    }
    if (ipRanges != null) {
      for (String item : ipRanges) {
        this.addToIpRanges(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIpRanges() {
    return this.ipRanges != null && !this.ipRanges.isEmpty();
  }
  
  public A addToUriDomains(int index,String item) {
    if (this.uriDomains == null) {this.uriDomains = new ArrayList<String>();}
    this.uriDomains.add(index, item);
    return (A)this;
  }
  
  public A setToUriDomains(int index,String item) {
    if (this.uriDomains == null) {this.uriDomains = new ArrayList<String>();}
    this.uriDomains.set(index, item); return (A)this;
  }
  
  public A addToUriDomains(java.lang.String... items) {
    if (this.uriDomains == null) {this.uriDomains = new ArrayList<String>();}
    for (String item : items) {this.uriDomains.add(item);} return (A)this;
  }
  
  public A addAllToUriDomains(Collection<String> items) {
    if (this.uriDomains == null) {this.uriDomains = new ArrayList<String>();}
    for (String item : items) {this.uriDomains.add(item);} return (A)this;
  }
  
  public A removeFromUriDomains(java.lang.String... items) {
    if (this.uriDomains == null) return (A)this;
    for (String item : items) { this.uriDomains.remove(item);} return (A)this;
  }
  
  public A removeAllFromUriDomains(Collection<String> items) {
    if (this.uriDomains == null) return (A)this;
    for (String item : items) { this.uriDomains.remove(item);} return (A)this;
  }
  
  public List<String> getUriDomains() {
    return this.uriDomains;
  }
  
  public String getUriDomain(int index) {
    return this.uriDomains.get(index);
  }
  
  public String getFirstUriDomain() {
    return this.uriDomains.get(0);
  }
  
  public String getLastUriDomain() {
    return this.uriDomains.get(uriDomains.size() - 1);
  }
  
  public String getMatchingUriDomain(Predicate<String> predicate) {
      for (String item : uriDomains) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingUriDomain(Predicate<String> predicate) {
      for (String item : uriDomains) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withUriDomains(List<String> uriDomains) {
    if (uriDomains != null) {
        this.uriDomains = new ArrayList();
        for (String item : uriDomains) {
          this.addToUriDomains(item);
        }
    } else {
      this.uriDomains = null;
    }
    return (A) this;
  }
  
  public A withUriDomains(java.lang.String... uriDomains) {
    if (this.uriDomains != null) {
        this.uriDomains.clear();
        _visitables.remove("uriDomains");
    }
    if (uriDomains != null) {
      for (String item : uriDomains) {
        this.addToUriDomains(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasUriDomains() {
    return this.uriDomains != null && !this.uriDomains.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NameConstraintItemFluent that = (NameConstraintItemFluent) o;
    if (!java.util.Objects.equals(dnsDomains, that.dnsDomains)) return false;
    if (!java.util.Objects.equals(emailAddresses, that.emailAddresses)) return false;
    if (!java.util.Objects.equals(ipRanges, that.ipRanges)) return false;
    if (!java.util.Objects.equals(uriDomains, that.uriDomains)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(dnsDomains,  emailAddresses,  ipRanges,  uriDomains,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dnsDomains != null && !dnsDomains.isEmpty()) { sb.append("dnsDomains:"); sb.append(dnsDomains + ","); }
    if (emailAddresses != null && !emailAddresses.isEmpty()) { sb.append("emailAddresses:"); sb.append(emailAddresses + ","); }
    if (ipRanges != null && !ipRanges.isEmpty()) { sb.append("ipRanges:"); sb.append(ipRanges + ","); }
    if (uriDomains != null && !uriDomains.isEmpty()) { sb.append("uriDomains:"); sb.append(uriDomains + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}