package io.fabric8.certmanager.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertificateBuilder extends CertificateFluent<CertificateBuilder> implements VisitableBuilder<Certificate,CertificateBuilder>{
  public CertificateBuilder() {
    this(new Certificate());
  }
  
  public CertificateBuilder(CertificateFluent<?> fluent) {
    this(fluent, new Certificate());
  }
  
  public CertificateBuilder(CertificateFluent<?> fluent,Certificate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertificateBuilder(Certificate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertificateFluent<?> fluent;
  
  public Certificate build() {
    Certificate buildable = new Certificate(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}