package io.fabric8.certmanager.api.model.acme.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEIssuerDNS01ProviderRoute53Fluent<A extends ACMEIssuerDNS01ProviderRoute53Fluent<A>> extends BaseFluent<A>{
  public ACMEIssuerDNS01ProviderRoute53Fluent() {
  }
  
  public ACMEIssuerDNS01ProviderRoute53Fluent(ACMEIssuerDNS01ProviderRoute53 instance) {
    this.copyInstance(instance);
  }
  private String accessKeyID;
  private SecretKeySelectorBuilder accessKeyIDSecretRef;
  private Route53AuthBuilder auth;
  private String hostedZoneID;
  private String region;
  private String role;
  private SecretKeySelectorBuilder secretAccessKeySecretRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ACMEIssuerDNS01ProviderRoute53 instance) {
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderRoute53());
    if (instance != null) {
          this.withAccessKeyID(instance.getAccessKeyID());
          this.withAccessKeyIDSecretRef(instance.getAccessKeyIDSecretRef());
          this.withAuth(instance.getAuth());
          this.withHostedZoneID(instance.getHostedZoneID());
          this.withRegion(instance.getRegion());
          this.withRole(instance.getRole());
          this.withSecretAccessKeySecretRef(instance.getSecretAccessKeySecretRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAccessKeyID() {
    return this.accessKeyID;
  }
  
  public A withAccessKeyID(String accessKeyID) {
    this.accessKeyID = accessKeyID;
    return (A) this;
  }
  
  public boolean hasAccessKeyID() {
    return this.accessKeyID != null;
  }
  
  public SecretKeySelector buildAccessKeyIDSecretRef() {
    return this.accessKeyIDSecretRef != null ? this.accessKeyIDSecretRef.build() : null;
  }
  
  public A withAccessKeyIDSecretRef(SecretKeySelector accessKeyIDSecretRef) {
    this._visitables.remove("accessKeyIDSecretRef");
    if (accessKeyIDSecretRef != null) {
        this.accessKeyIDSecretRef = new SecretKeySelectorBuilder(accessKeyIDSecretRef);
        this._visitables.get("accessKeyIDSecretRef").add(this.accessKeyIDSecretRef);
    } else {
        this.accessKeyIDSecretRef = null;
        this._visitables.get("accessKeyIDSecretRef").remove(this.accessKeyIDSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasAccessKeyIDSecretRef() {
    return this.accessKeyIDSecretRef != null;
  }
  
  public A withNewAccessKeyIDSecretRef(String key,String name) {
    return (A)withAccessKeyIDSecretRef(new SecretKeySelector(key, name));
  }
  
  public AccessKeyIDSecretRefNested<A> withNewAccessKeyIDSecretRef() {
    return new AccessKeyIDSecretRefNested(null);
  }
  
  public AccessKeyIDSecretRefNested<A> withNewAccessKeyIDSecretRefLike(SecretKeySelector item) {
    return new AccessKeyIDSecretRefNested(item);
  }
  
  public AccessKeyIDSecretRefNested<A> editAccessKeyIDSecretRef() {
    return withNewAccessKeyIDSecretRefLike(java.util.Optional.ofNullable(buildAccessKeyIDSecretRef()).orElse(null));
  }
  
  public AccessKeyIDSecretRefNested<A> editOrNewAccessKeyIDSecretRef() {
    return withNewAccessKeyIDSecretRefLike(java.util.Optional.ofNullable(buildAccessKeyIDSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public AccessKeyIDSecretRefNested<A> editOrNewAccessKeyIDSecretRefLike(SecretKeySelector item) {
    return withNewAccessKeyIDSecretRefLike(java.util.Optional.ofNullable(buildAccessKeyIDSecretRef()).orElse(item));
  }
  
  public Route53Auth buildAuth() {
    return this.auth != null ? this.auth.build() : null;
  }
  
  public A withAuth(Route53Auth auth) {
    this._visitables.remove("auth");
    if (auth != null) {
        this.auth = new Route53AuthBuilder(auth);
        this._visitables.get("auth").add(this.auth);
    } else {
        this.auth = null;
        this._visitables.get("auth").remove(this.auth);
    }
    return (A) this;
  }
  
  public boolean hasAuth() {
    return this.auth != null;
  }
  
  public AuthNested<A> withNewAuth() {
    return new AuthNested(null);
  }
  
  public AuthNested<A> withNewAuthLike(Route53Auth item) {
    return new AuthNested(item);
  }
  
  public AuthNested<A> editAuth() {
    return withNewAuthLike(java.util.Optional.ofNullable(buildAuth()).orElse(null));
  }
  
  public AuthNested<A> editOrNewAuth() {
    return withNewAuthLike(java.util.Optional.ofNullable(buildAuth()).orElse(new Route53AuthBuilder().build()));
  }
  
  public AuthNested<A> editOrNewAuthLike(Route53Auth item) {
    return withNewAuthLike(java.util.Optional.ofNullable(buildAuth()).orElse(item));
  }
  
  public String getHostedZoneID() {
    return this.hostedZoneID;
  }
  
  public A withHostedZoneID(String hostedZoneID) {
    this.hostedZoneID = hostedZoneID;
    return (A) this;
  }
  
  public boolean hasHostedZoneID() {
    return this.hostedZoneID != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public String getRole() {
    return this.role;
  }
  
  public A withRole(String role) {
    this.role = role;
    return (A) this;
  }
  
  public boolean hasRole() {
    return this.role != null;
  }
  
  public SecretKeySelector buildSecretAccessKeySecretRef() {
    return this.secretAccessKeySecretRef != null ? this.secretAccessKeySecretRef.build() : null;
  }
  
  public A withSecretAccessKeySecretRef(SecretKeySelector secretAccessKeySecretRef) {
    this._visitables.remove("secretAccessKeySecretRef");
    if (secretAccessKeySecretRef != null) {
        this.secretAccessKeySecretRef = new SecretKeySelectorBuilder(secretAccessKeySecretRef);
        this._visitables.get("secretAccessKeySecretRef").add(this.secretAccessKeySecretRef);
    } else {
        this.secretAccessKeySecretRef = null;
        this._visitables.get("secretAccessKeySecretRef").remove(this.secretAccessKeySecretRef);
    }
    return (A) this;
  }
  
  public boolean hasSecretAccessKeySecretRef() {
    return this.secretAccessKeySecretRef != null;
  }
  
  public A withNewSecretAccessKeySecretRef(String key,String name) {
    return (A)withSecretAccessKeySecretRef(new SecretKeySelector(key, name));
  }
  
  public SecretAccessKeySecretRefNested<A> withNewSecretAccessKeySecretRef() {
    return new SecretAccessKeySecretRefNested(null);
  }
  
  public SecretAccessKeySecretRefNested<A> withNewSecretAccessKeySecretRefLike(SecretKeySelector item) {
    return new SecretAccessKeySecretRefNested(item);
  }
  
  public SecretAccessKeySecretRefNested<A> editSecretAccessKeySecretRef() {
    return withNewSecretAccessKeySecretRefLike(java.util.Optional.ofNullable(buildSecretAccessKeySecretRef()).orElse(null));
  }
  
  public SecretAccessKeySecretRefNested<A> editOrNewSecretAccessKeySecretRef() {
    return withNewSecretAccessKeySecretRefLike(java.util.Optional.ofNullable(buildSecretAccessKeySecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public SecretAccessKeySecretRefNested<A> editOrNewSecretAccessKeySecretRefLike(SecretKeySelector item) {
    return withNewSecretAccessKeySecretRefLike(java.util.Optional.ofNullable(buildSecretAccessKeySecretRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerDNS01ProviderRoute53Fluent that = (ACMEIssuerDNS01ProviderRoute53Fluent) o;
    if (!java.util.Objects.equals(accessKeyID, that.accessKeyID)) return false;
    if (!java.util.Objects.equals(accessKeyIDSecretRef, that.accessKeyIDSecretRef)) return false;
    if (!java.util.Objects.equals(auth, that.auth)) return false;
    if (!java.util.Objects.equals(hostedZoneID, that.hostedZoneID)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(role, that.role)) return false;
    if (!java.util.Objects.equals(secretAccessKeySecretRef, that.secretAccessKeySecretRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessKeyID,  accessKeyIDSecretRef,  auth,  hostedZoneID,  region,  role,  secretAccessKeySecretRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessKeyID != null) { sb.append("accessKeyID:"); sb.append(accessKeyID + ","); }
    if (accessKeyIDSecretRef != null) { sb.append("accessKeyIDSecretRef:"); sb.append(accessKeyIDSecretRef + ","); }
    if (auth != null) { sb.append("auth:"); sb.append(auth + ","); }
    if (hostedZoneID != null) { sb.append("hostedZoneID:"); sb.append(hostedZoneID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (secretAccessKeySecretRef != null) { sb.append("secretAccessKeySecretRef:"); sb.append(secretAccessKeySecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AccessKeyIDSecretRefNested<N> extends SecretKeySelectorFluent<AccessKeyIDSecretRefNested<N>> implements Nested<N>{
    AccessKeyIDSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderRoute53Fluent.this.withAccessKeyIDSecretRef(builder.build());
    }
    
    public N endAccessKeyIDSecretRef() {
      return and();
    }
    
  
  }
  public class AuthNested<N> extends Route53AuthFluent<AuthNested<N>> implements Nested<N>{
    AuthNested(Route53Auth item) {
      this.builder = new Route53AuthBuilder(this, item);
    }
    Route53AuthBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderRoute53Fluent.this.withAuth(builder.build());
    }
    
    public N endAuth() {
      return and();
    }
    
  
  }
  public class SecretAccessKeySecretRefNested<N> extends SecretKeySelectorFluent<SecretAccessKeySecretRefNested<N>> implements Nested<N>{
    SecretAccessKeySecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderRoute53Fluent.this.withSecretAccessKeySecretRef(builder.build());
    }
    
    public N endSecretAccessKeySecretRef() {
      return and();
    }
    
  
  }

}