package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEChallengeSolverHTTP01GatewayHTTPRouteFluent<A extends ACMEChallengeSolverHTTP01GatewayHTTPRouteFluent<A>> extends BaseFluent<A>{
  public ACMEChallengeSolverHTTP01GatewayHTTPRouteFluent() {
  }
  
  public ACMEChallengeSolverHTTP01GatewayHTTPRouteFluent(ACMEChallengeSolverHTTP01GatewayHTTPRoute instance) {
    this.copyInstance(instance);
  }
  private Map<String,String> labels;
  private List<ParentReference> parentRefs = new ArrayList<ParentReference>();
  private ACMEChallengeSolverHTTP01IngressPodTemplateBuilder podTemplate;
  private String serviceType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ACMEChallengeSolverHTTP01GatewayHTTPRoute instance) {
    instance = (instance != null ? instance : new ACMEChallengeSolverHTTP01GatewayHTTPRoute());
    if (instance != null) {
          this.withLabels(instance.getLabels());
          this.withParentRefs(instance.getParentRefs());
          this.withPodTemplate(instance.getPodTemplate());
          this.withServiceType(instance.getServiceType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getLabels() {
    return this.labels;
  }
  
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) {
      this.labels = null;
    } else {
      this.labels = new LinkedHashMap(labels);
    }
    return (A) this;
  }
  
  public boolean hasLabels() {
    return this.labels != null;
  }
  
  public A addToParentRefs(int index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReference>();}
    this.parentRefs.add(index, item);
    return (A)this;
  }
  
  public A setToParentRefs(int index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReference>();}
    this.parentRefs.set(index, item); return (A)this;
  }
  
  public A addToParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference... items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReference>();}
    for (ParentReference item : items) {this.parentRefs.add(item);} return (A)this;
  }
  
  public A addAllToParentRefs(Collection<ParentReference> items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReference>();}
    for (ParentReference item : items) {this.parentRefs.add(item);} return (A)this;
  }
  
  public A removeFromParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference... items) {
    if (this.parentRefs == null) return (A)this;
    for (ParentReference item : items) { this.parentRefs.remove(item);} return (A)this;
  }
  
  public A removeAllFromParentRefs(Collection<ParentReference> items) {
    if (this.parentRefs == null) return (A)this;
    for (ParentReference item : items) { this.parentRefs.remove(item);} return (A)this;
  }
  
  public List<ParentReference> getParentRefs() {
    return this.parentRefs;
  }
  
  public ParentReference getParentRef(int index) {
    return this.parentRefs.get(index);
  }
  
  public ParentReference getFirstParentRef() {
    return this.parentRefs.get(0);
  }
  
  public ParentReference getLastParentRef() {
    return this.parentRefs.get(parentRefs.size() - 1);
  }
  
  public ParentReference getMatchingParentRef(Predicate<ParentReference> predicate) {
      for (ParentReference item : parentRefs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingParentRef(Predicate<ParentReference> predicate) {
      for (ParentReference item : parentRefs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withParentRefs(List<ParentReference> parentRefs) {
    if (parentRefs != null) {
        this.parentRefs = new ArrayList();
        for (ParentReference item : parentRefs) {
          this.addToParentRefs(item);
        }
    } else {
      this.parentRefs = null;
    }
    return (A) this;
  }
  
  public A withParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference... parentRefs) {
    if (this.parentRefs != null) {
        this.parentRefs.clear();
        _visitables.remove("parentRefs");
    }
    if (parentRefs != null) {
      for (ParentReference item : parentRefs) {
        this.addToParentRefs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasParentRefs() {
    return this.parentRefs != null && !this.parentRefs.isEmpty();
  }
  
  public ACMEChallengeSolverHTTP01IngressPodTemplate buildPodTemplate() {
    return this.podTemplate != null ? this.podTemplate.build() : null;
  }
  
  public A withPodTemplate(ACMEChallengeSolverHTTP01IngressPodTemplate podTemplate) {
    this._visitables.remove("podTemplate");
    if (podTemplate != null) {
        this.podTemplate = new ACMEChallengeSolverHTTP01IngressPodTemplateBuilder(podTemplate);
        this._visitables.get("podTemplate").add(this.podTemplate);
    } else {
        this.podTemplate = null;
        this._visitables.get("podTemplate").remove(this.podTemplate);
    }
    return (A) this;
  }
  
  public boolean hasPodTemplate() {
    return this.podTemplate != null;
  }
  
  public PodTemplateNested<A> withNewPodTemplate() {
    return new PodTemplateNested(null);
  }
  
  public PodTemplateNested<A> withNewPodTemplateLike(ACMEChallengeSolverHTTP01IngressPodTemplate item) {
    return new PodTemplateNested(item);
  }
  
  public PodTemplateNested<A> editPodTemplate() {
    return withNewPodTemplateLike(java.util.Optional.ofNullable(buildPodTemplate()).orElse(null));
  }
  
  public PodTemplateNested<A> editOrNewPodTemplate() {
    return withNewPodTemplateLike(java.util.Optional.ofNullable(buildPodTemplate()).orElse(new ACMEChallengeSolverHTTP01IngressPodTemplateBuilder().build()));
  }
  
  public PodTemplateNested<A> editOrNewPodTemplateLike(ACMEChallengeSolverHTTP01IngressPodTemplate item) {
    return withNewPodTemplateLike(java.util.Optional.ofNullable(buildPodTemplate()).orElse(item));
  }
  
  public String getServiceType() {
    return this.serviceType;
  }
  
  public A withServiceType(String serviceType) {
    this.serviceType = serviceType;
    return (A) this;
  }
  
  public boolean hasServiceType() {
    return this.serviceType != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEChallengeSolverHTTP01GatewayHTTPRouteFluent that = (ACMEChallengeSolverHTTP01GatewayHTTPRouteFluent) o;
    if (!java.util.Objects.equals(labels, that.labels)) return false;
    if (!java.util.Objects.equals(parentRefs, that.parentRefs)) return false;
    if (!java.util.Objects.equals(podTemplate, that.podTemplate)) return false;
    if (!java.util.Objects.equals(serviceType, that.serviceType)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(labels,  parentRefs,  podTemplate,  serviceType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (parentRefs != null && !parentRefs.isEmpty()) { sb.append("parentRefs:"); sb.append(parentRefs + ","); }
    if (podTemplate != null) { sb.append("podTemplate:"); sb.append(podTemplate + ","); }
    if (serviceType != null) { sb.append("serviceType:"); sb.append(serviceType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PodTemplateNested<N> extends ACMEChallengeSolverHTTP01IngressPodTemplateFluent<PodTemplateNested<N>> implements Nested<N>{
    PodTemplateNested(ACMEChallengeSolverHTTP01IngressPodTemplate item) {
      this.builder = new ACMEChallengeSolverHTTP01IngressPodTemplateBuilder(this, item);
    }
    ACMEChallengeSolverHTTP01IngressPodTemplateBuilder builder;
    
    public N and() {
      return (N) ACMEChallengeSolverHTTP01GatewayHTTPRouteFluent.this.withPodTemplate(builder.build());
    }
    
    public N endPodTemplate() {
      return and();
    }
    
  
  }

}