package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ACMEChallengeBuilder extends ACMEChallengeFluent<ACMEChallengeBuilder> implements VisitableBuilder<ACMEChallenge,ACMEChallengeBuilder>{
  public ACMEChallengeBuilder() {
    this(new ACMEChallenge());
  }
  
  public ACMEChallengeBuilder(ACMEChallengeFluent<?> fluent) {
    this(fluent, new ACMEChallenge());
  }
  
  public ACMEChallengeBuilder(ACMEChallengeFluent<?> fluent,ACMEChallenge instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ACMEChallengeBuilder(ACMEChallenge instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ACMEChallengeFluent<?> fluent;
  
  public ACMEChallenge build() {
    ACMEChallenge buildable = new ACMEChallenge(fluent.getToken(),fluent.getType(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}