package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEAuthorizationFluent<A extends ACMEAuthorizationFluent<A>> extends BaseFluent<A>{
  public ACMEAuthorizationFluent() {
  }
  
  public ACMEAuthorizationFluent(ACMEAuthorization instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ACMEChallengeBuilder> challenges = new ArrayList<ACMEChallengeBuilder>();
  private String identifier;
  private String initialState;
  private String url;
  private Boolean wildcard;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ACMEAuthorization instance) {
    instance = (instance != null ? instance : new ACMEAuthorization());
    if (instance != null) {
          this.withChallenges(instance.getChallenges());
          this.withIdentifier(instance.getIdentifier());
          this.withInitialState(instance.getInitialState());
          this.withUrl(instance.getUrl());
          this.withWildcard(instance.getWildcard());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToChallenges(int index,ACMEChallenge item) {
    if (this.challenges == null) {this.challenges = new ArrayList<ACMEChallengeBuilder>();}
    ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
    if (index < 0 || index >= challenges.size()) {
        _visitables.get("challenges").add(builder);
        challenges.add(builder);
    } else {
        _visitables.get("challenges").add(builder);
        challenges.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToChallenges(int index,ACMEChallenge item) {
    if (this.challenges == null) {this.challenges = new ArrayList<ACMEChallengeBuilder>();}
    ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
    if (index < 0 || index >= challenges.size()) {
        _visitables.get("challenges").add(builder);
        challenges.add(builder);
    } else {
        _visitables.get("challenges").add(builder);
        challenges.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToChallenges(io.fabric8.certmanager.api.model.acme.v1.ACMEChallenge... items) {
    if (this.challenges == null) {this.challenges = new ArrayList<ACMEChallengeBuilder>();}
    for (ACMEChallenge item : items) {ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);_visitables.get("challenges").add(builder);this.challenges.add(builder);} return (A)this;
  }
  
  public A addAllToChallenges(Collection<ACMEChallenge> items) {
    if (this.challenges == null) {this.challenges = new ArrayList<ACMEChallengeBuilder>();}
    for (ACMEChallenge item : items) {ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);_visitables.get("challenges").add(builder);this.challenges.add(builder);} return (A)this;
  }
  
  public A removeFromChallenges(io.fabric8.certmanager.api.model.acme.v1.ACMEChallenge... items) {
    if (this.challenges == null) return (A)this;
    for (ACMEChallenge item : items) {ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);_visitables.get("challenges").remove(builder); this.challenges.remove(builder);} return (A)this;
  }
  
  public A removeAllFromChallenges(Collection<ACMEChallenge> items) {
    if (this.challenges == null) return (A)this;
    for (ACMEChallenge item : items) {ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);_visitables.get("challenges").remove(builder); this.challenges.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromChallenges(Predicate<ACMEChallengeBuilder> predicate) {
    if (challenges == null) return (A) this;
    final Iterator<ACMEChallengeBuilder> each = challenges.iterator();
    final List visitables = _visitables.get("challenges");
    while (each.hasNext()) {
      ACMEChallengeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ACMEChallenge> buildChallenges() {
    return this.challenges != null ? build(challenges) : null;
  }
  
  public ACMEChallenge buildChallenge(int index) {
    return this.challenges.get(index).build();
  }
  
  public ACMEChallenge buildFirstChallenge() {
    return this.challenges.get(0).build();
  }
  
  public ACMEChallenge buildLastChallenge() {
    return this.challenges.get(challenges.size() - 1).build();
  }
  
  public ACMEChallenge buildMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
      for (ACMEChallengeBuilder item : challenges) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
      for (ACMEChallengeBuilder item : challenges) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withChallenges(List<ACMEChallenge> challenges) {
    if (this.challenges != null) {
      this._visitables.get("challenges").clear();
    }
    if (challenges != null) {
        this.challenges = new ArrayList();
        for (ACMEChallenge item : challenges) {
          this.addToChallenges(item);
        }
    } else {
      this.challenges = null;
    }
    return (A) this;
  }
  
  public A withChallenges(io.fabric8.certmanager.api.model.acme.v1.ACMEChallenge... challenges) {
    if (this.challenges != null) {
        this.challenges.clear();
        _visitables.remove("challenges");
    }
    if (challenges != null) {
      for (ACMEChallenge item : challenges) {
        this.addToChallenges(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasChallenges() {
    return this.challenges != null && !this.challenges.isEmpty();
  }
  
  public A addNewChallenge(String token,String type,String url) {
    return (A)addToChallenges(new ACMEChallenge(token, type, url));
  }
  
  public ChallengesNested<A> addNewChallenge() {
    return new ChallengesNested(-1, null);
  }
  
  public ChallengesNested<A> addNewChallengeLike(ACMEChallenge item) {
    return new ChallengesNested(-1, item);
  }
  
  public ChallengesNested<A> setNewChallengeLike(int index,ACMEChallenge item) {
    return new ChallengesNested(index, item);
  }
  
  public ChallengesNested<A> editChallenge(int index) {
    if (challenges.size() <= index) throw new RuntimeException("Can't edit challenges. Index exceeds size.");
    return setNewChallengeLike(index, buildChallenge(index));
  }
  
  public ChallengesNested<A> editFirstChallenge() {
    if (challenges.size() == 0) throw new RuntimeException("Can't edit first challenges. The list is empty.");
    return setNewChallengeLike(0, buildChallenge(0));
  }
  
  public ChallengesNested<A> editLastChallenge() {
    int index = challenges.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last challenges. The list is empty.");
    return setNewChallengeLike(index, buildChallenge(index));
  }
  
  public ChallengesNested<A> editMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<challenges.size();i++) { 
    if (predicate.test(challenges.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching challenges. No match found.");
    return setNewChallengeLike(index, buildChallenge(index));
  }
  
  public String getIdentifier() {
    return this.identifier;
  }
  
  public A withIdentifier(String identifier) {
    this.identifier = identifier;
    return (A) this;
  }
  
  public boolean hasIdentifier() {
    return this.identifier != null;
  }
  
  public String getInitialState() {
    return this.initialState;
  }
  
  public A withInitialState(String initialState) {
    this.initialState = initialState;
    return (A) this;
  }
  
  public boolean hasInitialState() {
    return this.initialState != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public Boolean getWildcard() {
    return this.wildcard;
  }
  
  public A withWildcard(Boolean wildcard) {
    this.wildcard = wildcard;
    return (A) this;
  }
  
  public boolean hasWildcard() {
    return this.wildcard != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEAuthorizationFluent that = (ACMEAuthorizationFluent) o;
    if (!java.util.Objects.equals(challenges, that.challenges)) return false;
    if (!java.util.Objects.equals(identifier, that.identifier)) return false;
    if (!java.util.Objects.equals(initialState, that.initialState)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(wildcard, that.wildcard)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(challenges,  identifier,  initialState,  url,  wildcard,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (challenges != null && !challenges.isEmpty()) { sb.append("challenges:"); sb.append(challenges + ","); }
    if (identifier != null) { sb.append("identifier:"); sb.append(identifier + ","); }
    if (initialState != null) { sb.append("initialState:"); sb.append(initialState + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (wildcard != null) { sb.append("wildcard:"); sb.append(wildcard + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withWildcard() {
    return withWildcard(true);
  }
  public class ChallengesNested<N> extends ACMEChallengeFluent<ChallengesNested<N>> implements Nested<N>{
    ChallengesNested(int index,ACMEChallenge item) {
      this.index = index;
      this.builder = new ACMEChallengeBuilder(this, item);
    }
    ACMEChallengeBuilder builder;
    int index;
    
    public N and() {
      return (N) ACMEAuthorizationFluent.this.setToChallenges(index,builder.build());
    }
    
    public N endChallenge() {
      return and();
    }
    
  
  }

}