/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.certmanager.api.model.v1.CertificateAdditionalOutputFormat;
import io.fabric8.certmanager.api.model.v1.CertificateAdditionalOutputFormatBuilder;
import io.fabric8.certmanager.api.model.v1.CertificateAdditionalOutputFormatFluent;
import io.fabric8.certmanager.api.model.v1.CertificateKeystores;
import io.fabric8.certmanager.api.model.v1.CertificateKeystoresBuilder;
import io.fabric8.certmanager.api.model.v1.CertificateKeystoresFluent;
import io.fabric8.certmanager.api.model.v1.CertificatePrivateKey;
import io.fabric8.certmanager.api.model.v1.CertificatePrivateKeyBuilder;
import io.fabric8.certmanager.api.model.v1.CertificatePrivateKeyFluent;
import io.fabric8.certmanager.api.model.v1.CertificateSecretTemplate;
import io.fabric8.certmanager.api.model.v1.CertificateSecretTemplateBuilder;
import io.fabric8.certmanager.api.model.v1.CertificateSecretTemplateFluent;
import io.fabric8.certmanager.api.model.v1.CertificateSpec;
import io.fabric8.certmanager.api.model.v1.NameConstraints;
import io.fabric8.certmanager.api.model.v1.NameConstraintsBuilder;
import io.fabric8.certmanager.api.model.v1.NameConstraintsFluent;
import io.fabric8.certmanager.api.model.v1.OtherName;
import io.fabric8.certmanager.api.model.v1.OtherNameBuilder;
import io.fabric8.certmanager.api.model.v1.OtherNameFluent;
import io.fabric8.certmanager.api.model.v1.X509Subject;
import io.fabric8.certmanager.api.model.v1.X509SubjectBuilder;
import io.fabric8.certmanager.api.model.v1.X509SubjectFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CertificateSpecFluent<A extends CertificateSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<CertificateAdditionalOutputFormatBuilder> additionalOutputFormats = new ArrayList();
    private String commonName;
    private List<String> dnsNames = new ArrayList<String>();
    private Duration duration;
    private List<String> emailAddresses = new ArrayList<String>();
    private Boolean encodeUsagesInRequest;
    private List<String> ipAddresses = new ArrayList<String>();
    private Boolean isCA;
    private ObjectReferenceBuilder issuerRef;
    private CertificateKeystoresBuilder keystores;
    private String literalSubject;
    private NameConstraintsBuilder nameConstraints;
    private ArrayList<OtherNameBuilder> otherNames = new ArrayList();
    private CertificatePrivateKeyBuilder privateKey;
    private Duration renewBefore;
    private Integer renewBeforePercentage;
    private Integer revisionHistoryLimit;
    private String secretName;
    private CertificateSecretTemplateBuilder secretTemplate;
    private X509SubjectBuilder subject;
    private List<String> uris = new ArrayList<String>();
    private List<String> usages = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public CertificateSpecFluent() {
    }

    public CertificateSpecFluent(CertificateSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CertificateSpec instance) {
        CertificateSpec certificateSpec = instance = instance != null ? instance : new CertificateSpec();
        if (instance != null) {
            this.withAdditionalOutputFormats(instance.getAdditionalOutputFormats());
            this.withCommonName(instance.getCommonName());
            this.withDnsNames(instance.getDnsNames());
            this.withDuration(instance.getDuration());
            this.withEmailAddresses(instance.getEmailAddresses());
            this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
            this.withIpAddresses(instance.getIpAddresses());
            this.withIsCA(instance.getIsCA());
            this.withIssuerRef(instance.getIssuerRef());
            this.withKeystores(instance.getKeystores());
            this.withLiteralSubject(instance.getLiteralSubject());
            this.withNameConstraints(instance.getNameConstraints());
            this.withOtherNames(instance.getOtherNames());
            this.withPrivateKey(instance.getPrivateKey());
            this.withRenewBefore(instance.getRenewBefore());
            this.withRenewBeforePercentage(instance.getRenewBeforePercentage());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withSecretName(instance.getSecretName());
            this.withSecretTemplate(instance.getSecretTemplate());
            this.withSubject(instance.getSubject());
            this.withUris(instance.getUris());
            this.withUsages(instance.getUsages());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalOutputFormats(int index, CertificateAdditionalOutputFormat item) {
        if (this.additionalOutputFormats == null) {
            this.additionalOutputFormats = new ArrayList();
        }
        CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);
        if (index < 0 || index >= this.additionalOutputFormats.size()) {
            this._visitables.get((Object)"additionalOutputFormats").add(builder);
            this.additionalOutputFormats.add(builder);
        } else {
            this._visitables.get((Object)"additionalOutputFormats").add(index, builder);
            this.additionalOutputFormats.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAdditionalOutputFormats(int index, CertificateAdditionalOutputFormat item) {
        if (this.additionalOutputFormats == null) {
            this.additionalOutputFormats = new ArrayList();
        }
        CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);
        if (index < 0 || index >= this.additionalOutputFormats.size()) {
            this._visitables.get((Object)"additionalOutputFormats").add(builder);
            this.additionalOutputFormats.add(builder);
        } else {
            this._visitables.get((Object)"additionalOutputFormats").set(index, builder);
            this.additionalOutputFormats.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalOutputFormats(CertificateAdditionalOutputFormat ... items) {
        if (this.additionalOutputFormats == null) {
            this.additionalOutputFormats = new ArrayList();
        }
        for (CertificateAdditionalOutputFormat item : items) {
            CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);
            this._visitables.get((Object)"additionalOutputFormats").add(builder);
            this.additionalOutputFormats.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAdditionalOutputFormats(Collection<CertificateAdditionalOutputFormat> items) {
        if (this.additionalOutputFormats == null) {
            this.additionalOutputFormats = new ArrayList();
        }
        for (CertificateAdditionalOutputFormat item : items) {
            CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);
            this._visitables.get((Object)"additionalOutputFormats").add(builder);
            this.additionalOutputFormats.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalOutputFormats(CertificateAdditionalOutputFormat ... items) {
        if (this.additionalOutputFormats == null) {
            return (A)((Object)this);
        }
        for (CertificateAdditionalOutputFormat item : items) {
            CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);
            this._visitables.get((Object)"additionalOutputFormats").remove((Object)builder);
            this.additionalOutputFormats.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAdditionalOutputFormats(Collection<CertificateAdditionalOutputFormat> items) {
        if (this.additionalOutputFormats == null) {
            return (A)((Object)this);
        }
        for (CertificateAdditionalOutputFormat item : items) {
            CertificateAdditionalOutputFormatBuilder builder = new CertificateAdditionalOutputFormatBuilder(item);
            this._visitables.get((Object)"additionalOutputFormats").remove((Object)builder);
            this.additionalOutputFormats.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAdditionalOutputFormats(Predicate<CertificateAdditionalOutputFormatBuilder> predicate) {
        if (this.additionalOutputFormats == null) {
            return (A)((Object)this);
        }
        Iterator<CertificateAdditionalOutputFormatBuilder> each = this.additionalOutputFormats.iterator();
        List visitables = this._visitables.get((Object)"additionalOutputFormats");
        while (each.hasNext()) {
            CertificateAdditionalOutputFormatBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CertificateAdditionalOutputFormat> buildAdditionalOutputFormats() {
        return this.additionalOutputFormats != null ? CertificateSpecFluent.build(this.additionalOutputFormats) : null;
    }

    public CertificateAdditionalOutputFormat buildAdditionalOutputFormat(int index) {
        return this.additionalOutputFormats.get(index).build();
    }

    public CertificateAdditionalOutputFormat buildFirstAdditionalOutputFormat() {
        return this.additionalOutputFormats.get(0).build();
    }

    public CertificateAdditionalOutputFormat buildLastAdditionalOutputFormat() {
        return this.additionalOutputFormats.get(this.additionalOutputFormats.size() - 1).build();
    }

    public CertificateAdditionalOutputFormat buildMatchingAdditionalOutputFormat(Predicate<CertificateAdditionalOutputFormatBuilder> predicate) {
        for (CertificateAdditionalOutputFormatBuilder item : this.additionalOutputFormats) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAdditionalOutputFormat(Predicate<CertificateAdditionalOutputFormatBuilder> predicate) {
        for (CertificateAdditionalOutputFormatBuilder item : this.additionalOutputFormats) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalOutputFormats(List<CertificateAdditionalOutputFormat> additionalOutputFormats) {
        if (this.additionalOutputFormats != null) {
            this._visitables.get((Object)"additionalOutputFormats").clear();
        }
        if (additionalOutputFormats != null) {
            this.additionalOutputFormats = new ArrayList();
            for (CertificateAdditionalOutputFormat item : additionalOutputFormats) {
                this.addToAdditionalOutputFormats(item);
            }
        } else {
            this.additionalOutputFormats = null;
        }
        return (A)((Object)this);
    }

    public A withAdditionalOutputFormats(CertificateAdditionalOutputFormat ... additionalOutputFormats) {
        if (this.additionalOutputFormats != null) {
            this.additionalOutputFormats.clear();
            this._visitables.remove((Object)"additionalOutputFormats");
        }
        if (additionalOutputFormats != null) {
            for (CertificateAdditionalOutputFormat item : additionalOutputFormats) {
                this.addToAdditionalOutputFormats(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAdditionalOutputFormats() {
        return this.additionalOutputFormats != null && !this.additionalOutputFormats.isEmpty();
    }

    public A addNewAdditionalOutputFormat(String type) {
        return this.addToAdditionalOutputFormats(new CertificateAdditionalOutputFormat(type));
    }

    public AdditionalOutputFormatsNested<A> addNewAdditionalOutputFormat() {
        return new AdditionalOutputFormatsNested(-1, null);
    }

    public AdditionalOutputFormatsNested<A> addNewAdditionalOutputFormatLike(CertificateAdditionalOutputFormat item) {
        return new AdditionalOutputFormatsNested(-1, item);
    }

    public AdditionalOutputFormatsNested<A> setNewAdditionalOutputFormatLike(int index, CertificateAdditionalOutputFormat item) {
        return new AdditionalOutputFormatsNested(index, item);
    }

    public AdditionalOutputFormatsNested<A> editAdditionalOutputFormat(int index) {
        if (this.additionalOutputFormats.size() <= index) {
            throw new RuntimeException("Can't edit additionalOutputFormats. Index exceeds size.");
        }
        return this.setNewAdditionalOutputFormatLike(index, this.buildAdditionalOutputFormat(index));
    }

    public AdditionalOutputFormatsNested<A> editFirstAdditionalOutputFormat() {
        if (this.additionalOutputFormats.size() == 0) {
            throw new RuntimeException("Can't edit first additionalOutputFormats. The list is empty.");
        }
        return this.setNewAdditionalOutputFormatLike(0, this.buildAdditionalOutputFormat(0));
    }

    public AdditionalOutputFormatsNested<A> editLastAdditionalOutputFormat() {
        int index = this.additionalOutputFormats.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last additionalOutputFormats. The list is empty.");
        }
        return this.setNewAdditionalOutputFormatLike(index, this.buildAdditionalOutputFormat(index));
    }

    public AdditionalOutputFormatsNested<A> editMatchingAdditionalOutputFormat(Predicate<CertificateAdditionalOutputFormatBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.additionalOutputFormats.size(); ++i) {
            if (!predicate.test(this.additionalOutputFormats.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching additionalOutputFormats. No match found.");
        }
        return this.setNewAdditionalOutputFormatLike(index, this.buildAdditionalOutputFormat(index));
    }

    public String getCommonName() {
        return this.commonName;
    }

    public A withCommonName(String commonName) {
        this.commonName = commonName;
        return (A)((Object)this);
    }

    public boolean hasCommonName() {
        return this.commonName != null;
    }

    public A addToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDnsNames(String ... items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    public String getDnsName(int index) {
        return this.dnsNames.get(index);
    }

    public String getFirstDnsName() {
        return this.dnsNames.get(0);
    }

    public String getLastDnsName() {
        return this.dnsNames.get(this.dnsNames.size() - 1);
    }

    public String getMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDnsNames(List<String> dnsNames) {
        if (dnsNames != null) {
            this.dnsNames = new ArrayList<String>();
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        } else {
            this.dnsNames = null;
        }
        return (A)((Object)this);
    }

    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
            this._visitables.remove((Object)"dnsNames");
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    public Duration getDuration() {
        return this.duration;
    }

    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public A addToEmailAddresses(int index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToEmailAddresses(int index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToEmailAddresses(String ... items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEmailAddresses(Collection<String> items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEmailAddresses(String ... items) {
        if (this.emailAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.emailAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEmailAddresses(Collection<String> items) {
        if (this.emailAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.emailAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    public String getEmailAddress(int index) {
        return this.emailAddresses.get(index);
    }

    public String getFirstEmailAddress() {
        return this.emailAddresses.get(0);
    }

    public String getLastEmailAddress() {
        return this.emailAddresses.get(this.emailAddresses.size() - 1);
    }

    public String getMatchingEmailAddress(Predicate<String> predicate) {
        for (String item : this.emailAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEmailAddress(Predicate<String> predicate) {
        for (String item : this.emailAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEmailAddresses(List<String> emailAddresses) {
        if (emailAddresses != null) {
            this.emailAddresses = new ArrayList<String>();
            for (String item : emailAddresses) {
                this.addToEmailAddresses(item);
            }
        } else {
            this.emailAddresses = null;
        }
        return (A)((Object)this);
    }

    public A withEmailAddresses(String ... emailAddresses) {
        if (this.emailAddresses != null) {
            this.emailAddresses.clear();
            this._visitables.remove((Object)"emailAddresses");
        }
        if (emailAddresses != null) {
            for (String item : emailAddresses) {
                this.addToEmailAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEmailAddresses() {
        return this.emailAddresses != null && !this.emailAddresses.isEmpty();
    }

    public Boolean getEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest;
    }

    public A withEncodeUsagesInRequest(Boolean encodeUsagesInRequest) {
        this.encodeUsagesInRequest = encodeUsagesInRequest;
        return (A)((Object)this);
    }

    public boolean hasEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest != null;
    }

    public A addToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public String getIpAddress(int index) {
        return this.ipAddresses.get(index);
    }

    public String getFirstIpAddress() {
        return this.ipAddresses.get(0);
    }

    public String getLastIpAddress() {
        return this.ipAddresses.get(this.ipAddresses.size() - 1);
    }

    public String getMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIpAddresses(List<String> ipAddresses) {
        if (ipAddresses != null) {
            this.ipAddresses = new ArrayList<String>();
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        } else {
            this.ipAddresses = null;
        }
        return (A)((Object)this);
    }

    public A withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses != null) {
            this.ipAddresses.clear();
            this._visitables.remove((Object)"ipAddresses");
        }
        if (ipAddresses != null) {
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIpAddresses() {
        return this.ipAddresses != null && !this.ipAddresses.isEmpty();
    }

    public Boolean getIsCA() {
        return this.isCA;
    }

    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)((Object)this);
    }

    public boolean hasIsCA() {
        return this.isCA != null;
    }

    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.remove((Object)"issuerRef");
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        }
        return (A)((Object)this);
    }

    public boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    public IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNested(null);
    }

    public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNested(item);
    }

    public IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(null));
    }

    public IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(item));
    }

    public CertificateKeystores buildKeystores() {
        return this.keystores != null ? this.keystores.build() : null;
    }

    public A withKeystores(CertificateKeystores keystores) {
        this._visitables.remove((Object)"keystores");
        if (keystores != null) {
            this.keystores = new CertificateKeystoresBuilder(keystores);
            this._visitables.get((Object)"keystores").add(this.keystores);
        } else {
            this.keystores = null;
            this._visitables.get((Object)"keystores").remove((Object)this.keystores);
        }
        return (A)((Object)this);
    }

    public boolean hasKeystores() {
        return this.keystores != null;
    }

    public KeystoresNested<A> withNewKeystores() {
        return new KeystoresNested(null);
    }

    public KeystoresNested<A> withNewKeystoresLike(CertificateKeystores item) {
        return new KeystoresNested(item);
    }

    public KeystoresNested<A> editKeystores() {
        return this.withNewKeystoresLike(Optional.ofNullable(this.buildKeystores()).orElse(null));
    }

    public KeystoresNested<A> editOrNewKeystores() {
        return this.withNewKeystoresLike(Optional.ofNullable(this.buildKeystores()).orElse(new CertificateKeystoresBuilder().build()));
    }

    public KeystoresNested<A> editOrNewKeystoresLike(CertificateKeystores item) {
        return this.withNewKeystoresLike(Optional.ofNullable(this.buildKeystores()).orElse(item));
    }

    public String getLiteralSubject() {
        return this.literalSubject;
    }

    public A withLiteralSubject(String literalSubject) {
        this.literalSubject = literalSubject;
        return (A)((Object)this);
    }

    public boolean hasLiteralSubject() {
        return this.literalSubject != null;
    }

    public NameConstraints buildNameConstraints() {
        return this.nameConstraints != null ? this.nameConstraints.build() : null;
    }

    public A withNameConstraints(NameConstraints nameConstraints) {
        this._visitables.remove((Object)"nameConstraints");
        if (nameConstraints != null) {
            this.nameConstraints = new NameConstraintsBuilder(nameConstraints);
            this._visitables.get((Object)"nameConstraints").add(this.nameConstraints);
        } else {
            this.nameConstraints = null;
            this._visitables.get((Object)"nameConstraints").remove((Object)this.nameConstraints);
        }
        return (A)((Object)this);
    }

    public boolean hasNameConstraints() {
        return this.nameConstraints != null;
    }

    public NameConstraintsNested<A> withNewNameConstraints() {
        return new NameConstraintsNested(null);
    }

    public NameConstraintsNested<A> withNewNameConstraintsLike(NameConstraints item) {
        return new NameConstraintsNested(item);
    }

    public NameConstraintsNested<A> editNameConstraints() {
        return this.withNewNameConstraintsLike(Optional.ofNullable(this.buildNameConstraints()).orElse(null));
    }

    public NameConstraintsNested<A> editOrNewNameConstraints() {
        return this.withNewNameConstraintsLike(Optional.ofNullable(this.buildNameConstraints()).orElse(new NameConstraintsBuilder().build()));
    }

    public NameConstraintsNested<A> editOrNewNameConstraintsLike(NameConstraints item) {
        return this.withNewNameConstraintsLike(Optional.ofNullable(this.buildNameConstraints()).orElse(item));
    }

    public A addToOtherNames(int index, OtherName item) {
        if (this.otherNames == null) {
            this.otherNames = new ArrayList();
        }
        OtherNameBuilder builder = new OtherNameBuilder(item);
        if (index < 0 || index >= this.otherNames.size()) {
            this._visitables.get((Object)"otherNames").add(builder);
            this.otherNames.add(builder);
        } else {
            this._visitables.get((Object)"otherNames").add(index, builder);
            this.otherNames.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOtherNames(int index, OtherName item) {
        if (this.otherNames == null) {
            this.otherNames = new ArrayList();
        }
        OtherNameBuilder builder = new OtherNameBuilder(item);
        if (index < 0 || index >= this.otherNames.size()) {
            this._visitables.get((Object)"otherNames").add(builder);
            this.otherNames.add(builder);
        } else {
            this._visitables.get((Object)"otherNames").set(index, builder);
            this.otherNames.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOtherNames(OtherName ... items) {
        if (this.otherNames == null) {
            this.otherNames = new ArrayList();
        }
        for (OtherName item : items) {
            OtherNameBuilder builder = new OtherNameBuilder(item);
            this._visitables.get((Object)"otherNames").add(builder);
            this.otherNames.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOtherNames(Collection<OtherName> items) {
        if (this.otherNames == null) {
            this.otherNames = new ArrayList();
        }
        for (OtherName item : items) {
            OtherNameBuilder builder = new OtherNameBuilder(item);
            this._visitables.get((Object)"otherNames").add(builder);
            this.otherNames.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOtherNames(OtherName ... items) {
        if (this.otherNames == null) {
            return (A)((Object)this);
        }
        for (OtherName item : items) {
            OtherNameBuilder builder = new OtherNameBuilder(item);
            this._visitables.get((Object)"otherNames").remove((Object)builder);
            this.otherNames.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOtherNames(Collection<OtherName> items) {
        if (this.otherNames == null) {
            return (A)((Object)this);
        }
        for (OtherName item : items) {
            OtherNameBuilder builder = new OtherNameBuilder(item);
            this._visitables.get((Object)"otherNames").remove((Object)builder);
            this.otherNames.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOtherNames(Predicate<OtherNameBuilder> predicate) {
        if (this.otherNames == null) {
            return (A)((Object)this);
        }
        Iterator<OtherNameBuilder> each = this.otherNames.iterator();
        List visitables = this._visitables.get((Object)"otherNames");
        while (each.hasNext()) {
            OtherNameBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<OtherName> buildOtherNames() {
        return this.otherNames != null ? CertificateSpecFluent.build(this.otherNames) : null;
    }

    public OtherName buildOtherName(int index) {
        return this.otherNames.get(index).build();
    }

    public OtherName buildFirstOtherName() {
        return this.otherNames.get(0).build();
    }

    public OtherName buildLastOtherName() {
        return this.otherNames.get(this.otherNames.size() - 1).build();
    }

    public OtherName buildMatchingOtherName(Predicate<OtherNameBuilder> predicate) {
        for (OtherNameBuilder item : this.otherNames) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOtherName(Predicate<OtherNameBuilder> predicate) {
        for (OtherNameBuilder item : this.otherNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOtherNames(List<OtherName> otherNames) {
        if (this.otherNames != null) {
            this._visitables.get((Object)"otherNames").clear();
        }
        if (otherNames != null) {
            this.otherNames = new ArrayList();
            for (OtherName item : otherNames) {
                this.addToOtherNames(item);
            }
        } else {
            this.otherNames = null;
        }
        return (A)((Object)this);
    }

    public A withOtherNames(OtherName ... otherNames) {
        if (this.otherNames != null) {
            this.otherNames.clear();
            this._visitables.remove((Object)"otherNames");
        }
        if (otherNames != null) {
            for (OtherName item : otherNames) {
                this.addToOtherNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOtherNames() {
        return this.otherNames != null && !this.otherNames.isEmpty();
    }

    public A addNewOtherName(String oid, String utf8Value) {
        return this.addToOtherNames(new OtherName(oid, utf8Value));
    }

    public OtherNamesNested<A> addNewOtherName() {
        return new OtherNamesNested(-1, null);
    }

    public OtherNamesNested<A> addNewOtherNameLike(OtherName item) {
        return new OtherNamesNested(-1, item);
    }

    public OtherNamesNested<A> setNewOtherNameLike(int index, OtherName item) {
        return new OtherNamesNested(index, item);
    }

    public OtherNamesNested<A> editOtherName(int index) {
        if (this.otherNames.size() <= index) {
            throw new RuntimeException("Can't edit otherNames. Index exceeds size.");
        }
        return this.setNewOtherNameLike(index, this.buildOtherName(index));
    }

    public OtherNamesNested<A> editFirstOtherName() {
        if (this.otherNames.size() == 0) {
            throw new RuntimeException("Can't edit first otherNames. The list is empty.");
        }
        return this.setNewOtherNameLike(0, this.buildOtherName(0));
    }

    public OtherNamesNested<A> editLastOtherName() {
        int index = this.otherNames.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last otherNames. The list is empty.");
        }
        return this.setNewOtherNameLike(index, this.buildOtherName(index));
    }

    public OtherNamesNested<A> editMatchingOtherName(Predicate<OtherNameBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.otherNames.size(); ++i) {
            if (!predicate.test(this.otherNames.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching otherNames. No match found.");
        }
        return this.setNewOtherNameLike(index, this.buildOtherName(index));
    }

    public CertificatePrivateKey buildPrivateKey() {
        return this.privateKey != null ? this.privateKey.build() : null;
    }

    public A withPrivateKey(CertificatePrivateKey privateKey) {
        this._visitables.remove((Object)"privateKey");
        if (privateKey != null) {
            this.privateKey = new CertificatePrivateKeyBuilder(privateKey);
            this._visitables.get((Object)"privateKey").add(this.privateKey);
        } else {
            this.privateKey = null;
            this._visitables.get((Object)"privateKey").remove((Object)this.privateKey);
        }
        return (A)((Object)this);
    }

    public boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    public A withNewPrivateKey(String algorithm, String encoding, String rotationPolicy, Integer size) {
        return this.withPrivateKey(new CertificatePrivateKey(algorithm, encoding, rotationPolicy, size));
    }

    public PrivateKeyNested<A> withNewPrivateKey() {
        return new PrivateKeyNested(null);
    }

    public PrivateKeyNested<A> withNewPrivateKeyLike(CertificatePrivateKey item) {
        return new PrivateKeyNested(item);
    }

    public PrivateKeyNested<A> editPrivateKey() {
        return this.withNewPrivateKeyLike(Optional.ofNullable(this.buildPrivateKey()).orElse(null));
    }

    public PrivateKeyNested<A> editOrNewPrivateKey() {
        return this.withNewPrivateKeyLike(Optional.ofNullable(this.buildPrivateKey()).orElse(new CertificatePrivateKeyBuilder().build()));
    }

    public PrivateKeyNested<A> editOrNewPrivateKeyLike(CertificatePrivateKey item) {
        return this.withNewPrivateKeyLike(Optional.ofNullable(this.buildPrivateKey()).orElse(item));
    }

    public Duration getRenewBefore() {
        return this.renewBefore;
    }

    public A withRenewBefore(Duration renewBefore) {
        this.renewBefore = renewBefore;
        return (A)((Object)this);
    }

    public boolean hasRenewBefore() {
        return this.renewBefore != null;
    }

    public Integer getRenewBeforePercentage() {
        return this.renewBeforePercentage;
    }

    public A withRenewBeforePercentage(Integer renewBeforePercentage) {
        this.renewBeforePercentage = renewBeforePercentage;
        return (A)((Object)this);
    }

    public boolean hasRenewBeforePercentage() {
        return this.renewBeforePercentage != null;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)((Object)this);
    }

    public boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)((Object)this);
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    public CertificateSecretTemplate buildSecretTemplate() {
        return this.secretTemplate != null ? this.secretTemplate.build() : null;
    }

    public A withSecretTemplate(CertificateSecretTemplate secretTemplate) {
        this._visitables.remove((Object)"secretTemplate");
        if (secretTemplate != null) {
            this.secretTemplate = new CertificateSecretTemplateBuilder(secretTemplate);
            this._visitables.get((Object)"secretTemplate").add(this.secretTemplate);
        } else {
            this.secretTemplate = null;
            this._visitables.get((Object)"secretTemplate").remove((Object)this.secretTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretTemplate() {
        return this.secretTemplate != null;
    }

    public SecretTemplateNested<A> withNewSecretTemplate() {
        return new SecretTemplateNested(null);
    }

    public SecretTemplateNested<A> withNewSecretTemplateLike(CertificateSecretTemplate item) {
        return new SecretTemplateNested(item);
    }

    public SecretTemplateNested<A> editSecretTemplate() {
        return this.withNewSecretTemplateLike(Optional.ofNullable(this.buildSecretTemplate()).orElse(null));
    }

    public SecretTemplateNested<A> editOrNewSecretTemplate() {
        return this.withNewSecretTemplateLike(Optional.ofNullable(this.buildSecretTemplate()).orElse(new CertificateSecretTemplateBuilder().build()));
    }

    public SecretTemplateNested<A> editOrNewSecretTemplateLike(CertificateSecretTemplate item) {
        return this.withNewSecretTemplateLike(Optional.ofNullable(this.buildSecretTemplate()).orElse(item));
    }

    public X509Subject buildSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    public A withSubject(X509Subject subject) {
        this._visitables.remove((Object)"subject");
        if (subject != null) {
            this.subject = new X509SubjectBuilder(subject);
            this._visitables.get((Object)"subject").add(this.subject);
        } else {
            this.subject = null;
            this._visitables.get((Object)"subject").remove((Object)this.subject);
        }
        return (A)((Object)this);
    }

    public boolean hasSubject() {
        return this.subject != null;
    }

    public SubjectNested<A> withNewSubject() {
        return new SubjectNested(null);
    }

    public SubjectNested<A> withNewSubjectLike(X509Subject item) {
        return new SubjectNested(item);
    }

    public SubjectNested<A> editSubject() {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(null));
    }

    public SubjectNested<A> editOrNewSubject() {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(new X509SubjectBuilder().build()));
    }

    public SubjectNested<A> editOrNewSubjectLike(X509Subject item) {
        return this.withNewSubjectLike(Optional.ofNullable(this.buildSubject()).orElse(item));
    }

    public A addToUris(int index, String item) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.add(index, item);
        return (A)((Object)this);
    }

    public A setToUris(int index, String item) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.set(index, item);
        return (A)((Object)this);
    }

    public A addToUris(String ... items) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        for (String item : items) {
            this.uris.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUris(Collection<String> items) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        for (String item : items) {
            this.uris.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUris(String ... items) {
        if (this.uris == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.uris.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUris(Collection<String> items) {
        if (this.uris == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.uris.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUris() {
        return this.uris;
    }

    public String getUri(int index) {
        return this.uris.get(index);
    }

    public String getFirstUri() {
        return this.uris.get(0);
    }

    public String getLastUri() {
        return this.uris.get(this.uris.size() - 1);
    }

    public String getMatchingUri(Predicate<String> predicate) {
        for (String item : this.uris) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUri(Predicate<String> predicate) {
        for (String item : this.uris) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUris(List<String> uris) {
        if (uris != null) {
            this.uris = new ArrayList<String>();
            for (String item : uris) {
                this.addToUris(item);
            }
        } else {
            this.uris = null;
        }
        return (A)((Object)this);
    }

    public A withUris(String ... uris) {
        if (this.uris != null) {
            this.uris.clear();
            this._visitables.remove((Object)"uris");
        }
        if (uris != null) {
            for (String item : uris) {
                this.addToUris(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUris() {
        return this.uris != null && !this.uris.isEmpty();
    }

    public A addToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)((Object)this);
    }

    public A setToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)((Object)this);
    }

    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUsages(String ... items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUsages(Collection<String> items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUsages() {
        return this.usages;
    }

    public String getUsage(int index) {
        return this.usages.get(index);
    }

    public String getFirstUsage() {
        return this.usages.get(0);
    }

    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)((Object)this);
    }

    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
            this._visitables.remove((Object)"usages");
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateSpecFluent that = (CertificateSpecFluent)((Object)o);
        if (!Objects.equals(this.additionalOutputFormats, that.additionalOutputFormats)) {
            return false;
        }
        if (!Objects.equals(this.commonName, that.commonName)) {
            return false;
        }
        if (!Objects.equals(this.dnsNames, that.dnsNames)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.emailAddresses, that.emailAddresses)) {
            return false;
        }
        if (!Objects.equals(this.encodeUsagesInRequest, that.encodeUsagesInRequest)) {
            return false;
        }
        if (!Objects.equals(this.ipAddresses, that.ipAddresses)) {
            return false;
        }
        if (!Objects.equals(this.isCA, that.isCA)) {
            return false;
        }
        if (!Objects.equals((Object)this.issuerRef, (Object)that.issuerRef)) {
            return false;
        }
        if (!Objects.equals((Object)this.keystores, (Object)that.keystores)) {
            return false;
        }
        if (!Objects.equals(this.literalSubject, that.literalSubject)) {
            return false;
        }
        if (!Objects.equals((Object)this.nameConstraints, (Object)that.nameConstraints)) {
            return false;
        }
        if (!Objects.equals(this.otherNames, that.otherNames)) {
            return false;
        }
        if (!Objects.equals((Object)this.privateKey, (Object)that.privateKey)) {
            return false;
        }
        if (!Objects.equals(this.renewBefore, that.renewBefore)) {
            return false;
        }
        if (!Objects.equals(this.renewBeforePercentage, that.renewBeforePercentage)) {
            return false;
        }
        if (!Objects.equals(this.revisionHistoryLimit, that.revisionHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretTemplate, (Object)that.secretTemplate)) {
            return false;
        }
        if (!Objects.equals((Object)this.subject, (Object)that.subject)) {
            return false;
        }
        if (!Objects.equals(this.uris, that.uris)) {
            return false;
        }
        if (!Objects.equals(this.usages, that.usages)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalOutputFormats, this.commonName, this.dnsNames, this.duration, this.emailAddresses, this.encodeUsagesInRequest, this.ipAddresses, this.isCA, this.issuerRef, this.keystores, this.literalSubject, this.nameConstraints, this.otherNames, this.privateKey, this.renewBefore, this.renewBeforePercentage, this.revisionHistoryLimit, this.secretName, this.secretTemplate, this.subject, this.uris, this.usages, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalOutputFormats != null && !this.additionalOutputFormats.isEmpty()) {
            sb.append("additionalOutputFormats:");
            sb.append(this.additionalOutputFormats + ",");
        }
        if (this.commonName != null) {
            sb.append("commonName:");
            sb.append(this.commonName + ",");
        }
        if (this.dnsNames != null && !this.dnsNames.isEmpty()) {
            sb.append("dnsNames:");
            sb.append(this.dnsNames + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.emailAddresses != null && !this.emailAddresses.isEmpty()) {
            sb.append("emailAddresses:");
            sb.append(this.emailAddresses + ",");
        }
        if (this.encodeUsagesInRequest != null) {
            sb.append("encodeUsagesInRequest:");
            sb.append(this.encodeUsagesInRequest + ",");
        }
        if (this.ipAddresses != null && !this.ipAddresses.isEmpty()) {
            sb.append("ipAddresses:");
            sb.append(this.ipAddresses + ",");
        }
        if (this.isCA != null) {
            sb.append("isCA:");
            sb.append(this.isCA + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append(this.issuerRef + ",");
        }
        if (this.keystores != null) {
            sb.append("keystores:");
            sb.append(this.keystores + ",");
        }
        if (this.literalSubject != null) {
            sb.append("literalSubject:");
            sb.append(this.literalSubject + ",");
        }
        if (this.nameConstraints != null) {
            sb.append("nameConstraints:");
            sb.append(this.nameConstraints + ",");
        }
        if (this.otherNames != null && !this.otherNames.isEmpty()) {
            sb.append("otherNames:");
            sb.append(this.otherNames + ",");
        }
        if (this.privateKey != null) {
            sb.append("privateKey:");
            sb.append(this.privateKey + ",");
        }
        if (this.renewBefore != null) {
            sb.append("renewBefore:");
            sb.append(this.renewBefore + ",");
        }
        if (this.renewBeforePercentage != null) {
            sb.append("renewBeforePercentage:");
            sb.append(this.renewBeforePercentage + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.secretTemplate != null) {
            sb.append("secretTemplate:");
            sb.append(this.secretTemplate + ",");
        }
        if (this.subject != null) {
            sb.append("subject:");
            sb.append(this.subject + ",");
        }
        if (this.uris != null && !this.uris.isEmpty()) {
            sb.append("uris:");
            sb.append(this.uris + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEncodeUsagesInRequest() {
        return this.withEncodeUsagesInRequest(true);
    }

    public A withIsCA() {
        return this.withIsCA(true);
    }

    public class SubjectNested<N>
    extends X509SubjectFluent<SubjectNested<N>>
    implements Nested<N> {
        X509SubjectBuilder builder;

        SubjectNested(X509Subject item) {
            this.builder = new X509SubjectBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withSubject(this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }

    public class SecretTemplateNested<N>
    extends CertificateSecretTemplateFluent<SecretTemplateNested<N>>
    implements Nested<N> {
        CertificateSecretTemplateBuilder builder;

        SecretTemplateNested(CertificateSecretTemplate item) {
            this.builder = new CertificateSecretTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withSecretTemplate(this.builder.build());
        }

        public N endSecretTemplate() {
            return this.and();
        }
    }

    public class PrivateKeyNested<N>
    extends CertificatePrivateKeyFluent<PrivateKeyNested<N>>
    implements Nested<N> {
        CertificatePrivateKeyBuilder builder;

        PrivateKeyNested(CertificatePrivateKey item) {
            this.builder = new CertificatePrivateKeyBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withPrivateKey(this.builder.build());
        }

        public N endPrivateKey() {
            return this.and();
        }
    }

    public class OtherNamesNested<N>
    extends OtherNameFluent<OtherNamesNested<N>>
    implements Nested<N> {
        OtherNameBuilder builder;
        int index;

        OtherNamesNested(int index, OtherName item) {
            this.index = index;
            this.builder = new OtherNameBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.setToOtherNames(this.index, this.builder.build());
        }

        public N endOtherName() {
            return this.and();
        }
    }

    public class NameConstraintsNested<N>
    extends NameConstraintsFluent<NameConstraintsNested<N>>
    implements Nested<N> {
        NameConstraintsBuilder builder;

        NameConstraintsNested(NameConstraints item) {
            this.builder = new NameConstraintsBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withNameConstraints(this.builder.build());
        }

        public N endNameConstraints() {
            return this.and();
        }
    }

    public class KeystoresNested<N>
    extends CertificateKeystoresFluent<KeystoresNested<N>>
    implements Nested<N> {
        CertificateKeystoresBuilder builder;

        KeystoresNested(CertificateKeystores item) {
            this.builder = new CertificateKeystoresBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withKeystores(this.builder.build());
        }

        public N endKeystores() {
            return this.and();
        }
    }

    public class IssuerRefNested<N>
    extends ObjectReferenceFluent<IssuerRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.withIssuerRef(this.builder.build());
        }

        public N endIssuerRef() {
            return this.and();
        }
    }

    public class AdditionalOutputFormatsNested<N>
    extends CertificateAdditionalOutputFormatFluent<AdditionalOutputFormatsNested<N>>
    implements Nested<N> {
        CertificateAdditionalOutputFormatBuilder builder;
        int index;

        AdditionalOutputFormatsNested(int index, CertificateAdditionalOutputFormat item) {
            this.index = index;
            this.builder = new CertificateAdditionalOutputFormatBuilder(this, item);
        }

        public N and() {
            return (N)CertificateSpecFluent.this.setToAdditionalOutputFormats(this.index, this.builder.build());
        }

        public N endAdditionalOutputFormat() {
            return this.and();
        }
    }
}

