/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.v1.CAIssuer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CAIssuerFluent<A extends CAIssuerFluent<A>>
extends BaseFluent<A> {
    private List<String> crlDistributionPoints = new ArrayList<String>();
    private List<String> issuingCertificateURLs = new ArrayList<String>();
    private List<String> ocspServers = new ArrayList<String>();
    private String secretName;
    private Map<String, Object> additionalProperties;

    public CAIssuerFluent() {
    }

    public CAIssuerFluent(CAIssuer instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CAIssuer instance) {
        CAIssuer cAIssuer = instance = instance != null ? instance : new CAIssuer();
        if (instance != null) {
            this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
            this.withIssuingCertificateURLs(instance.getIssuingCertificateURLs());
            this.withOcspServers(instance.getOcspServers());
            this.withSecretName(instance.getSecretName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(index, item);
        return (A)((Object)this);
    }

    public A setToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.set(index, item);
        return (A)((Object)this);
    }

    public A addToCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCrlDistributionPoints() {
        return this.crlDistributionPoints;
    }

    public String getCrlDistributionPoint(int index) {
        return this.crlDistributionPoints.get(index);
    }

    public String getFirstCrlDistributionPoint() {
        return this.crlDistributionPoints.get(0);
    }

    public String getLastCrlDistributionPoint() {
        return this.crlDistributionPoints.get(this.crlDistributionPoints.size() - 1);
    }

    public String getMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCrlDistributionPoints(List<String> crlDistributionPoints) {
        if (crlDistributionPoints != null) {
            this.crlDistributionPoints = new ArrayList<String>();
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        } else {
            this.crlDistributionPoints = null;
        }
        return (A)((Object)this);
    }

    public A withCrlDistributionPoints(String ... crlDistributionPoints) {
        if (this.crlDistributionPoints != null) {
            this.crlDistributionPoints.clear();
            this._visitables.remove((Object)"crlDistributionPoints");
        }
        if (crlDistributionPoints != null) {
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCrlDistributionPoints() {
        return this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty();
    }

    public A addToIssuingCertificateURLs(int index, String item) {
        if (this.issuingCertificateURLs == null) {
            this.issuingCertificateURLs = new ArrayList<String>();
        }
        this.issuingCertificateURLs.add(index, item);
        return (A)((Object)this);
    }

    public A setToIssuingCertificateURLs(int index, String item) {
        if (this.issuingCertificateURLs == null) {
            this.issuingCertificateURLs = new ArrayList<String>();
        }
        this.issuingCertificateURLs.set(index, item);
        return (A)((Object)this);
    }

    public A addToIssuingCertificateURLs(String ... items) {
        if (this.issuingCertificateURLs == null) {
            this.issuingCertificateURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.issuingCertificateURLs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIssuingCertificateURLs(Collection<String> items) {
        if (this.issuingCertificateURLs == null) {
            this.issuingCertificateURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.issuingCertificateURLs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIssuingCertificateURLs(String ... items) {
        if (this.issuingCertificateURLs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.issuingCertificateURLs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIssuingCertificateURLs(Collection<String> items) {
        if (this.issuingCertificateURLs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.issuingCertificateURLs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIssuingCertificateURLs() {
        return this.issuingCertificateURLs;
    }

    public String getIssuingCertificateURL(int index) {
        return this.issuingCertificateURLs.get(index);
    }

    public String getFirstIssuingCertificateURL() {
        return this.issuingCertificateURLs.get(0);
    }

    public String getLastIssuingCertificateURL() {
        return this.issuingCertificateURLs.get(this.issuingCertificateURLs.size() - 1);
    }

    public String getMatchingIssuingCertificateURL(Predicate<String> predicate) {
        for (String item : this.issuingCertificateURLs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIssuingCertificateURL(Predicate<String> predicate) {
        for (String item : this.issuingCertificateURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIssuingCertificateURLs(List<String> issuingCertificateURLs) {
        if (issuingCertificateURLs != null) {
            this.issuingCertificateURLs = new ArrayList<String>();
            for (String item : issuingCertificateURLs) {
                this.addToIssuingCertificateURLs(item);
            }
        } else {
            this.issuingCertificateURLs = null;
        }
        return (A)((Object)this);
    }

    public A withIssuingCertificateURLs(String ... issuingCertificateURLs) {
        if (this.issuingCertificateURLs != null) {
            this.issuingCertificateURLs.clear();
            this._visitables.remove((Object)"issuingCertificateURLs");
        }
        if (issuingCertificateURLs != null) {
            for (String item : issuingCertificateURLs) {
                this.addToIssuingCertificateURLs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIssuingCertificateURLs() {
        return this.issuingCertificateURLs != null && !this.issuingCertificateURLs.isEmpty();
    }

    public A addToOcspServers(int index, String item) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        this.ocspServers.add(index, item);
        return (A)((Object)this);
    }

    public A setToOcspServers(int index, String item) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        this.ocspServers.set(index, item);
        return (A)((Object)this);
    }

    public A addToOcspServers(String ... items) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ocspServers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOcspServers(Collection<String> items) {
        if (this.ocspServers == null) {
            this.ocspServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ocspServers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOcspServers(String ... items) {
        if (this.ocspServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ocspServers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOcspServers(Collection<String> items) {
        if (this.ocspServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ocspServers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOcspServers() {
        return this.ocspServers;
    }

    public String getOcspServer(int index) {
        return this.ocspServers.get(index);
    }

    public String getFirstOcspServer() {
        return this.ocspServers.get(0);
    }

    public String getLastOcspServer() {
        return this.ocspServers.get(this.ocspServers.size() - 1);
    }

    public String getMatchingOcspServer(Predicate<String> predicate) {
        for (String item : this.ocspServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOcspServer(Predicate<String> predicate) {
        for (String item : this.ocspServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOcspServers(List<String> ocspServers) {
        if (ocspServers != null) {
            this.ocspServers = new ArrayList<String>();
            for (String item : ocspServers) {
                this.addToOcspServers(item);
            }
        } else {
            this.ocspServers = null;
        }
        return (A)((Object)this);
    }

    public A withOcspServers(String ... ocspServers) {
        if (this.ocspServers != null) {
            this.ocspServers.clear();
            this._visitables.remove((Object)"ocspServers");
        }
        if (ocspServers != null) {
            for (String item : ocspServers) {
                this.addToOcspServers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOcspServers() {
        return this.ocspServers != null && !this.ocspServers.isEmpty();
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)((Object)this);
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CAIssuerFluent that = (CAIssuerFluent)((Object)o);
        if (!Objects.equals(this.crlDistributionPoints, that.crlDistributionPoints)) {
            return false;
        }
        if (!Objects.equals(this.issuingCertificateURLs, that.issuingCertificateURLs)) {
            return false;
        }
        if (!Objects.equals(this.ocspServers, that.ocspServers)) {
            return false;
        }
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.crlDistributionPoints, this.issuingCertificateURLs, this.ocspServers, this.secretName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty()) {
            sb.append("crlDistributionPoints:");
            sb.append(this.crlDistributionPoints + ",");
        }
        if (this.issuingCertificateURLs != null && !this.issuingCertificateURLs.isEmpty()) {
            sb.append("issuingCertificateURLs:");
            sb.append(this.issuingCertificateURLs + ",");
        }
        if (this.ocspServers != null && !this.ocspServers.isEmpty()) {
            sb.append("ocspServers:");
            sb.append(this.ocspServers + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

