/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel.tooling.util;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Namespace;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.NodeWithChildren;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLStringSource;
import de.pdark.decentxml.XMLWriter;
import io.fabric8.camel.tooling.util.CamelNamespaces;
import io.fabric8.camel.tooling.util.XmlModel;
import io.fabric8.camel.tooling.util.parser.PatchedXMLParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.blueprint.CamelRouteContextFactoryBean;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;

public class RouteXml {
    public static Logger LOG = LoggerFactory.getLogger(RouteXml.class);
    private JAXBContext _jaxbContext;
    private ClassLoader classLoader = CamelContextFactoryBean.class.getClassLoader();
    protected TransformerFactory transformerFactory = TransformerFactory.newInstance();
    protected DocumentBuilder documentBuilder = this.createDocumentBuilder();

    protected DocumentBuilder documentBuilder(ErrorHandler handler) {
        DocumentBuilder db = this.createDocumentBuilder();
        db.setErrorHandler(handler);
        return db;
    }

    public JAXBContext jaxbContext() throws JAXBException {
        if (this._jaxbContext == null) {
            String packageName = "org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.spring";
            this._jaxbContext = JAXBContext.newInstance((String)packageName, (ClassLoader)this.classLoader);
        }
        return this._jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this._jaxbContext = jaxbContext;
    }

    protected Document createExemplarDoc() throws IOException {
        String exemplar = "io/fabric8/camel/tooling/exemplar.xml";
        URL url = CamelNamespaces.findResource(exemplar, null);
        if (url != null) {
            return this.parse(new XMLIOSource(url));
        }
        LOG.warn("Could not find file {} on the class path", (Object)exemplar);
        Document d = new Document();
        d.addNode(new Element("beans", CamelNamespaces.springNamespace));
        return d;
    }

    private Document parse(XMLSource source) {
        PatchedXMLParser parser = new PatchedXMLParser();
        return parser.parse(source);
    }

    public XmlModel unmarshal(File file) throws Exception {
        Document doc = file.exists() ? this.parse(new XMLIOSource(file)) : this.createExemplarDoc();
        return this.unmarshal(doc, "XML File " + file);
    }

    public XmlModel unmarshal(String text) throws Exception {
        Document doc = text != null && text.trim().length() > 0 ? this.parse(new XMLStringSource(text)) : this.createExemplarDoc();
        return this.unmarshal(doc, "Text");
    }

    public XmlModel unmarshal(Document doc) throws Exception {
        return this.unmarshal(doc, "XML document " + doc);
    }

    public XmlModel unmarshal(Document doc, String message) throws Exception {
        Unmarshaller unmarshaller = this.jaxbContext().createUnmarshaller();
        HashMap<String, String> beans = new HashMap<String, String>();
        List<Node> beanElems = CamelNamespaces.nodesByNamespace(doc, "http://camel.apache.org/schema/spring", "bean");
        for (Node n : beanElems) {
            if (!(n instanceof Element)) continue;
            String id = ((Element)n).getAttributeValue("id");
            String cn = ((Element)n).getAttributeValue("class");
            if (id == null || cn == null) continue;
            beans.put(id, cn);
        }
        List<String[]> search = Arrays.asList({"http://camel.apache.org/schema/spring", "routeContext"}, {"http://camel.apache.org/schema/spring", "camelContext"}, {"http://camel.apache.org/schema/spring", "routes"}, {"http://camel.apache.org/schema/blueprint", "routeContext"}, {"http://camel.apache.org/schema/blueprint", "camelContext"}, {"http://camel.apache.org/schema/blueprint", "routes"});
        LinkedList<Node> found = new LinkedList<Node>();
        for (String[] pair : search) {
            List<Node> nodes = CamelNamespaces.nodesByNamespace(doc, pair[0], pair[1]);
            int n = nodes.size();
            if (n == 0) continue;
            if (n > 1) {
                LOG.warn(message + " contains " + n + " <" + pair[1] + "> elements. Only the first one will be used");
            }
            Node node = nodes.get(0);
            found.add(node);
        }
        if (found.size() > 0) {
            Node n = (Node)found.get(0);
            if (n != null) {
                CamelContextFactoryBean sc;
                String ns = CamelNamespaces.getNamespaceURI(n);
                Node parseNode = !ns.equals("http://camel.apache.org/schema/spring") ? this.cloneAndReplaceNamespace(n, ns, "http://camel.apache.org/schema/spring") : n;
                boolean justRoutes = false;
                boolean routesContext = false;
                String xmlText = CamelNamespaces.nodeWithNamespacesToText(parseNode, (Element)n);
                Object object = unmarshaller.unmarshal((Reader)new StringReader(xmlText));
                if (object instanceof CamelContextFactoryBean) {
                    LOG.debug("Found a valid CamelContextFactoryBean! {}", object);
                    sc = (CamelContextFactoryBean)object;
                } else if (object instanceof RoutesDefinition) {
                    justRoutes = true;
                    sc = new CamelContextFactoryBean();
                    sc.setRoutes(((RoutesDefinition)object).getRoutes());
                } else if (object instanceof org.apache.camel.spring.CamelRouteContextFactoryBean) {
                    routesContext = true;
                    sc = new CamelContextFactoryBean();
                    sc.setRoutes(((org.apache.camel.spring.CamelRouteContextFactoryBean)object).getRoutes());
                } else if (object instanceof CamelRouteContextFactoryBean) {
                    routesContext = true;
                    sc = new CamelContextFactoryBean();
                    sc.setRoutes(((CamelRouteContextFactoryBean)object).getRoutes());
                } else {
                    LOG.warn("Unmarshalled not a CamelContext: {}", object);
                    sc = new CamelContextFactoryBean();
                }
                return new XmlModel(sc, doc, beans, n, ns, justRoutes, routesContext);
            }
            LOG.info(message + " does not contain a CamelContext. Maybe the XML namespace is not spring: '{}' or blueprint: '{}'?", (Object)"http://camel.apache.org/schema/spring", (Object)"http://camel.apache.org/schema/blueprint");
            return new XmlModel(new CamelContextFactoryBean(), doc, beans, null, "http://camel.apache.org/schema/spring", false, false);
        }
        return null;
    }

    protected Node cloneAndReplaceNamespace(Node node, String oldNS, String newNS) {
        Node answer = node.copy();
        return this.replaceNamespace(answer, oldNS, newNS);
    }

    protected Node replaceNamespace(Node node, String oldNS, String newNS) {
        String ns;
        if (node instanceof Element && (ns = CamelNamespaces.getNamespaceURI(node)) != null && ns.equals(oldNS)) {
            Namespace namespace = ((Element)node).getNamespace();
            if (namespace != null && namespace.getURI() != null && namespace.getURI().equals(oldNS)) {
                ((Element)node).setNamespace(new Namespace(namespace.getPrefix(), newNS));
            }
            for (Attribute attr : ((Element)node).getAttributes()) {
                String value;
                if (!attr.getName().startsWith("xmlns") || (value = attr.getValue()) == null || !value.equals(oldNS)) continue;
                attr.setValue(newNS);
            }
        }
        if (node instanceof NodeWithChildren) {
            for (Node n : ((NodeWithChildren)node).getNodes()) {
                this.replaceNamespace(n, oldNS, newNS);
            }
        }
        return node;
    }

    public void marshal(File file, final CamelContextFactoryBean context) throws Exception {
        this.marshal(file, new Model2Model(){

            @Override
            public XmlModel transform(XmlModel model) {
                model.update(context);
                return model;
            }
        });
    }

    public void marshal(File file, final CamelContext context) throws Exception {
        this.marshal(file, new Model2Model(){

            @Override
            public XmlModel transform(XmlModel model) {
                RouteXml.this.copyRoutesToElement(context, model.getContextElement());
                return model;
            }
        });
    }

    public void copyRoutesToElement(List<RouteDefinition> routeDefinitionList, CamelContextFactoryBean contextElement) {
        List routes = contextElement.getRoutes();
        routes.clear();
        routes.addAll(routeDefinitionList);
    }

    public void copyRoutesToElement(CamelContext context, CamelContextFactoryBean contextElement) {
        if (context instanceof ModelCamelContext) {
            this.copyRoutesToElement(((ModelCamelContext)context).getRouteDefinitions(), contextElement);
        } else {
            LOG.error("Invalid camel context! ({})", (Object)context.getClass().getName());
        }
    }

    public void marshal(File file, final List<RouteDefinition> routeDefinitionList) throws Exception {
        this.marshal(file, new Model2Model(){

            @Override
            public XmlModel transform(XmlModel model) {
                RouteXml.this.copyRoutesToElement(routeDefinitionList, model.getContextElement());
                return model;
            }
        });
    }

    public void marshal(File file, Model2Model transformer) throws Exception {
        XmlModel model = this.unmarshal(file);
        this.marshal(file, transformer.transform(model));
    }

    public String marshalToText(String text, final List<RouteDefinition> routeDefinitionList) throws Exception {
        return this.marshalToText(text, new Model2Model(){

            @Override
            public XmlModel transform(XmlModel model) {
                RouteXml.this.copyRoutesToElement(routeDefinitionList, model.getContextElement());
                return model;
            }
        });
    }

    public String marshalToText(String text, Model2Model transformer) throws Exception {
        XmlModel model = this.unmarshal(text);
        return this.marshalToText(transformer.transform(model));
    }

    public void marshal(File file, XmlModel model) throws JAXBException, IOException {
        this.marshalToDoc(model);
        this.writeXml(model.getDoc(), file);
    }

    public String marshalToText(XmlModel model) throws JAXBException, IOException {
        this.marshalToDoc(model);
        return CamelNamespaces.xmlToText(model.getDoc());
    }

    protected void replaceCamelElement(Element docElem, Node camelElem, Node oldNode) {
        CamelNamespaces.replaceChild(docElem, camelElem, oldNode);
        if (camelElem instanceof Element && oldNode instanceof Element) {
            for (Attribute attr : ((Element)oldNode).getAttributes()) {
                if (!attr.getName().startsWith("xmlns")) continue;
                ((Element)camelElem).setAttribute(attr.getName(), attr.getValue());
            }
        }
    }

    public void marshalToDoc(XmlModel model) throws JAXBException {
        Marshaller marshaller = this.jaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        try {
            marshaller.setProperty("com.sun.xml.bind.indentString", (Object)"  ");
        }
        catch (Exception e) {
            LOG.debug("Property not supported: {}", (Throwable)e);
        }
        Object value = model.marshalRootElement();
        Document doc = model.getDoc();
        Element docElem = doc.getRootElement();
        StringWriter buffer = new StringWriter();
        marshaller.marshal(value, (Writer)buffer);
        String xml = buffer.toString();
        if (!model.getNs().equals("http://camel.apache.org/schema/spring")) {
            xml = xml.replaceAll("http://camel.apache.org/schema/spring", model.getNs());
        }
        Document camelDoc = this.parse(new XMLStringSource(xml));
        Element camelElem = camelDoc.getRootElement();
        if (model.isRoutesContext() && camelDoc.getRootElement().getName().equals("camelContext")) {
            camelDoc.getRootElement().setName("routeContext");
        }
        if (model.isJustRoutes()) {
            CamelNamespaces.replaceChild(doc, camelElem, docElem);
        } else if (model.getNode() != null) {
            this.replaceCamelElement(docElem, camelElem, model.getNode());
        } else {
            docElem.addNode(camelElem);
        }
    }

    public void writeXml(Document doc, File file) throws IOException {
        File parentDir = file.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        XMLWriter writer = new XMLWriter(new FileWriter(file));
        doc.toXML(writer);
        writer.close();
    }

    protected DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(false);
        dbf.setCoalescing(false);
        dbf.setNamespaceAware(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static interface Model2Model {
        public XmlModel transform(XmlModel var1);
    }
}

