/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.mapping;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.TreeIterator;
import de.pdark.decentxml.XMLUtils;
import de.pdark.decentxml.mapping.ElementHandlerFactory;
import de.pdark.decentxml.mapping.ElementName;
import de.pdark.decentxml.mapping.INodeHandler;
import de.pdark.decentxml.mapping.MappingException;
import de.pdark.decentxml.mapping.TextHandler;
import de.pdark.decentxml.mapping.TextHandlerFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMapper {
    private Map<String, INodeHandler> handlers = new HashMap<String, INodeHandler>();
    private INodeHandler textHandler;

    public JavaMapper setHandler(Object handler) {
        this.handlers.clear();
        Class<?> c = handler.getClass();
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(c.getMethods()));
        Method textMethod = this.locateTextHandler(methods);
        this.textHandler = TextHandlerFactory.create(handler, textMethod);
        for (Method m : methods) {
            if (Object.class.equals(m.getDeclaringClass())) continue;
            String[] names = this.getNames(m);
            INodeHandler elementHandler = ElementHandlerFactory.create(handler, m);
            for (String name : names) {
                INodeHandler existing = this.handlers.get(name);
                if (existing != null) {
                    throw new MappingException("The handler " + handler + " contains two methods to handle elements with the name " + name);
                }
                this.handlers.put(name, elementHandler);
            }
        }
        if (this.handlers.isEmpty() && textMethod == null) {
            throw new MappingException("No usable methods found; maybe they aren't public? Handler: " + handler);
        }
        return this;
    }

    private String[] getNames(Method m) {
        ElementName ann = m.getAnnotation(ElementName.class);
        if (ann != null) {
            return ann.value();
        }
        return new String[]{m.getName()};
    }

    private Method locateTextHandler(Set<Method> methods) {
        for (Method m : methods) {
            if (m.getAnnotation(TextHandler.class) == null) continue;
            methods.remove(m);
            return m;
        }
        for (Method m : methods) {
            if (!"text".equals(m.getName()) || m.getAnnotation(ElementName.class) != null) continue;
            methods.remove(m);
            return m;
        }
        return null;
    }

    public void apply(Document doc) {
        TreeIterator iter = doc.iterator();
        while (iter.hasNext()) {
            String name;
            INodeHandler handler;
            Node node = iter.next();
            if (XMLUtils.isText(node)) {
                this.textHandler.handle(node);
                continue;
            }
            if (!XMLUtils.isElement(node) || (handler = this.handlers.get(name = ((Element)node).getName())) == null) continue;
            handler.handle(node);
        }
    }
}

