/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.test;

import io.etcd.jetcd.launcher.Etcd;
import io.etcd.jetcd.launcher.EtcdCluster;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.Network;

public class EtcdClusterExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private static final Map<String, EtcdCluster> CLUSTERS = new ConcurrentHashMap<String, EtcdCluster>();
    private final EtcdCluster cluster;
    private final AtomicBoolean beforeAll;

    private EtcdClusterExtension(EtcdCluster cluster) {
        this.cluster = cluster;
        this.beforeAll = new AtomicBoolean();
    }

    public EtcdCluster cluster() {
        return this.cluster;
    }

    public void restart(long delay, TimeUnit unit) {
        try {
            this.cluster.restart(delay, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String clusterName() {
        return this.cluster.clusterName();
    }

    public List<URI> clientEndpoints() {
        return this.cluster.clientEndpoints();
    }

    public List<URI> peerEndpoints() {
        return this.cluster.peerEndpoints();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.beforeAll.set(true);
        this.before(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.before(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.beforeAll.set(false);
        this.after(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.after(context);
    }

    protected synchronized void before(ExtensionContext context) {
        EtcdCluster oldCluster = CLUSTERS.putIfAbsent(this.cluster.clusterName(), this.cluster);
        if (oldCluster == null) {
            this.cluster.start();
        }
    }

    protected synchronized void after(ExtensionContext context) {
        if (!this.beforeAll.get()) {
            try {
                this.cluster.close();
            }
            finally {
                CLUSTERS.remove(this.cluster.clusterName());
            }
        }
    }

    public static EtcdCluster cluster(String clusterName) {
        return CLUSTERS.get(clusterName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Etcd.Builder builder = new Etcd.Builder();

        public Builder withClusterName(String clusterName) {
            this.builder.withClusterName(clusterName);
            return this;
        }

        public Builder withPrefix(String prefix) {
            this.builder.withPrefix(prefix);
            return this;
        }

        public Builder withNodes(int nodes) {
            this.builder.withNodes(nodes);
            return this;
        }

        public Builder withSsl(boolean ssl) {
            this.builder.withSsl(ssl);
            return this;
        }

        public Builder withDebug(boolean debug) {
            this.builder.withDebug(debug);
            return this;
        }

        public Builder withAdditionalArgs(Collection<String> additionalArgs) {
            this.builder.withAdditionalArgs(additionalArgs);
            return this;
        }

        public Builder withImage(String image) {
            this.builder.withImage(image);
            return this;
        }

        public Builder withNetwork(Network network) {
            this.builder.withNetwork(network);
            return this;
        }

        public Builder withMountDirectory(boolean mountDirectory) {
            this.builder.withMountedDataDirectory(mountDirectory);
            return this;
        }

        public EtcdClusterExtension build() {
            return new EtcdClusterExtension(this.builder.build());
        }
    }
}

