/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.etcd.jetcd.launcher.EtcdCluster;
import io.etcd.jetcd.launcher.EtcdClusterFactory;
import java.net.URI;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClusterExtension
implements EtcdCluster,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdClusterExtension.class);
    private final EtcdCluster cluster;

    public EtcdClusterExtension(String clusterName, int nodes) {
        this(clusterName, nodes, false);
    }

    public EtcdClusterExtension(String clusterName, int nodes, boolean ssl) {
        this.cluster = EtcdClusterFactory.buildCluster((String)clusterName, (int)nodes, (boolean)ssl);
    }

    public EtcdClusterExtension(String clusterName, int nodes, boolean ssl, String ... additionalArgs) {
        this.cluster = EtcdClusterFactory.buildCluster((String)clusterName, (int)nodes, (boolean)ssl, (String[])additionalArgs);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.cluster.start();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        try {
            this.cluster.close();
        }
        catch (RuntimeException e) {
            LOG.warn("close() failed (but ignoring it)", (Throwable)e);
        }
    }

    public void start() {
        this.cluster.start();
    }

    public void restart() {
        this.cluster.restart();
    }

    public void close() {
        this.cluster.close();
    }

    @NonNull
    public List<URI> getClientEndpoints() {
        return this.cluster.getClientEndpoints();
    }

    @NonNull
    public List<URI> getPeerEndpoints() {
        return this.cluster.getPeerEndpoints();
    }
}

