/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.launcher;

import io.etcd.jetcd.launcher.EtcdCluster;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class EtcdContainer
implements AutoCloseable {
    public static final String ETCD_DOCKER_IMAGE_NAME = "gcr.io/etcd-development/etcd:v3.4.7";
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdCluster.class);
    private static final int ETCD_CLIENT_PORT = 2379;
    private static final int ETCD_PEER_PORT = 2380;
    private static final String ETCD_DATA_DIR = "/data.etcd";
    private final String endpoint;
    private final boolean ssl;
    private final FixedHostPortGenericContainer<?> container;
    private final LifecycleListener listener;
    private final Path dataDirectory;

    public EtcdContainer(Network network, LifecycleListener listener, boolean ssl, String clusterName, String endpoint, List<String> endpoints, String image, List<String> additionalArgs) {
        this.endpoint = endpoint;
        this.ssl = ssl;
        this.listener = listener;
        this.dataDirectory = EtcdContainer.createDataDirectory(endpoint);
        this.container = new FixedHostPortGenericContainer(image);
        this.container.withExposedPorts(new Integer[]{2380});
        this.container.withFixedExposedPort(EtcdContainer.getAvailablePort(), 2379);
        this.container.withNetwork(network);
        this.container.withNetworkAliases(new String[]{endpoint});
        this.container.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*ready to serve client requests.*", (int)1));
        this.container.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER).withPrefix(endpoint));
        this.container.addFileSystemBind(this.dataDirectory.toString(), ETCD_DATA_DIR, BindMode.READ_WRITE, SelinuxContext.SHARED);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("etcd");
        cmd.add("--name");
        cmd.add(endpoint);
        cmd.add("--advertise-client-urls");
        cmd.add((ssl ? "https" : "http") + "://0.0.0.0:" + 2379);
        cmd.add("--listen-client-urls");
        cmd.add((ssl ? "https" : "http") + "://0.0.0.0:" + 2379);
        cmd.add("--data-dir");
        cmd.add(ETCD_DATA_DIR);
        if (ssl) {
            this.container.withClasspathResourceMapping("ssl/cert/" + endpoint + ".pem", "/etc/ssl/etcd/server.pem", BindMode.READ_ONLY, SelinuxContext.SHARED);
            this.container.withClasspathResourceMapping("ssl/cert/" + endpoint + "-key.pem", "/etc/ssl/etcd/server-key.pem", BindMode.READ_ONLY, SelinuxContext.SHARED);
            cmd.add("--cert-file");
            cmd.add("/etc/ssl/etcd/server.pem");
            cmd.add("--key-file");
            cmd.add("/etc/ssl/etcd/server-key.pem");
        }
        if (endpoints.size() > 1) {
            cmd.add("--initial-advertise-peer-urls");
            cmd.add("http://" + endpoint + ":" + 2380);
            cmd.add("--listen-peer-urls");
            cmd.add("http://0.0.0.0:2380");
            cmd.add("--initial-cluster-token");
            cmd.add(clusterName);
            cmd.add("--initial-cluster");
            cmd.add(endpoints.stream().map(e -> e + "=http://" + e + ":" + 2380).collect(Collectors.joining(",")));
            cmd.add("--initial-cluster-state");
            cmd.add("new");
        }
        cmd.addAll(additionalArgs);
        if (!cmd.isEmpty()) {
            this.container.withCommand(cmd.toArray(new String[0]));
        }
    }

    private static Path createDataDirectory(String name) {
        try {
            String prefix = "jetcd_test_" + name + "_";
            if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                FileAttribute<Set<PosixFilePermission>> attribute = PosixFilePermissions.asFileAttribute(EnumSet.allOf(PosixFilePermission.class));
                return Files.createTempDirectory(prefix, attribute).toRealPath(new LinkOption[0]);
            }
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new ContainerLaunchException("Error creating data directory", (Throwable)e);
        }
    }

    private static void deleteDataDirectory(Path dir) {
        if (dir != null && Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                LOGGER.error("Error deleting directory {}", (Object)dir.toString(), (Object)e);
            }
        }
    }

    private static int getAvailablePort() {
        int n;
        ServerSocket ss = new ServerSocket();
        Throwable throwable = null;
        try {
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress((InetAddress)null, 0), 1);
            n = ss.getLocalPort();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    EtcdContainer.$closeResource(throwable, ss);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot find free port", e);
            }
        }
        EtcdContainer.$closeResource(throwable, ss);
        return n;
    }

    public void start() {
        LOGGER.debug("starting etcd container {} with command: {}", (Object)this.endpoint, (Object)String.join((CharSequence)" ", this.container.getCommandParts()));
        try {
            this.container.start();
            this.container.execInContainer(new String[]{"chmod", "o+rwx", "-R", ETCD_DATA_DIR});
            this.listener.started(this);
        }
        catch (Exception exception) {
            this.listener.failedToStart(this, exception);
        }
    }

    public void restart() {
        LOGGER.debug("restarting etcd container {} with command: {}", (Object)this.endpoint, (Object)String.join((CharSequence)" ", this.container.getCommandParts()));
        this.container.stop();
        this.container.start();
    }

    @Override
    public void close() {
        if (this.container != null) {
            this.container.stop();
        }
        EtcdContainer.deleteDataDirectory(this.dataDirectory);
    }

    public URI clientEndpoint() {
        return this.newURI(this.container.getContainerIpAddress(), this.container.getMappedPort(2379));
    }

    public URI peerEndpoint() {
        return this.newURI(this.container.getContainerIpAddress(), this.container.getMappedPort(2380));
    }

    private URI newURI(String host, int port) {
        try {
            return new URI(this.ssl ? "https" : "http", null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URISyntaxException should never happen here", e);
        }
    }

    static interface LifecycleListener {
        public void started(EtcdContainer var1);

        public void failedToStart(EtcdContainer var1, Exception var2);

        public void stopped(EtcdContainer var1);
    }
}

