/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.launcher;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.etcd.jetcd.launcher.EtcdCluster;
import io.etcd.jetcd.launcher.EtcdContainer;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

public class EtcdClusterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdClusterFactory.class);

    public static EtcdCluster buildCluster(@NonNull String clusterName, int nodes, boolean ssl) {
        return EtcdClusterFactory.buildCluster(clusterName, nodes, ssl, "gcr.io/etcd-development/etcd:v3.4.5", Collections.emptyList());
    }

    public static EtcdCluster buildCluster(@NonNull String clusterName, int nodes, boolean ssl, String ... additionalArgs) {
        return EtcdClusterFactory.buildCluster(clusterName, nodes, ssl, "gcr.io/etcd-development/etcd:v3.4.5", Arrays.asList(additionalArgs));
    }

    public static EtcdCluster buildCluster(@NonNull String clusterName, int nodes, boolean ssl, @NonNull String image, List<String> additionalArgs) {
        Network.NetworkImpl network = Network.builder().id(clusterName).build();
        final CountDownLatch latch = new CountDownLatch(nodes);
        final AtomicBoolean failedToStart = new AtomicBoolean(false);
        EtcdContainer.LifecycleListener listener = new EtcdContainer.LifecycleListener(){

            @Override
            public void started(EtcdContainer container) {
                latch.countDown();
            }

            @Override
            public void failedToStart(EtcdContainer container, Exception exception) {
                LOGGER.error("Exception while starting etcd container: ", (Throwable)exception);
                failedToStart.set(true);
                latch.countDown();
            }

            @Override
            public void stopped(EtcdContainer container) {
            }
        };
        List endpoints = IntStream.range(0, nodes).mapToObj(i -> "etcd" + i).collect(Collectors.toList());
        final List containers = endpoints.stream().map(arg_0 -> EtcdClusterFactory.lambda$buildCluster$1((Network)network, listener, ssl, clusterName, endpoints, image, additionalArgs, arg_0)).collect(Collectors.toList());
        return new EtcdCluster(){

            @Override
            public void start() {
                for (EtcdContainer container : containers) {
                    new Thread(container::start).start();
                }
                try {
                    latch.await(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (failedToStart.get()) {
                    throw new IllegalStateException("Cluster failed to start");
                }
            }

            @Override
            public void close() {
                containers.forEach(EtcdContainer::close);
            }

            @Override
            public void restart() {
                containers.forEach(EtcdContainer::restart);
            }

            @Override
            @NonNull
            public List<URI> getClientEndpoints() {
                return containers.stream().map(EtcdContainer::clientEndpoint).collect(Collectors.toList());
            }

            @Override
            @NonNull
            public List<URI> getPeerEndpoints() {
                return containers.stream().map(EtcdContainer::peerEndpoint).collect(Collectors.toList());
            }
        };
    }

    private static /* synthetic */ EtcdContainer lambda$buildCluster$1(Network network, EtcdContainer.LifecycleListener listener, boolean ssl, String clusterName, List endpoints, String image, List additionalArgs, String e) {
        return new EtcdContainer(network, listener, ssl, clusterName, e, endpoints, image, additionalArgs);
    }
}

