/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.api;

import io.etcd.jetcd.api.CompactionRequest;
import io.etcd.jetcd.api.CompactionResponse;
import io.etcd.jetcd.api.DeleteRangeRequest;
import io.etcd.jetcd.api.DeleteRangeResponse;
import io.etcd.jetcd.api.KVGrpc;
import io.etcd.jetcd.api.PutRequest;
import io.etcd.jetcd.api.PutResponse;
import io.etcd.jetcd.api.RangeRequest;
import io.etcd.jetcd.api.RangeResponse;
import io.etcd.jetcd.api.TxnRequest;
import io.etcd.jetcd.api.TxnResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.grpc.stub.ClientCalls;

public final class VertxKVGrpc {
    private static final int METHODID_RANGE = 0;
    private static final int METHODID_PUT = 1;
    private static final int METHODID_DELETE_RANGE = 2;
    private static final int METHODID_TXN = 3;
    private static final int METHODID_COMPACT = 4;

    private VertxKVGrpc() {
    }

    public static KVVertxStub newVertxStub(Channel channel) {
        return new KVVertxStub(channel);
    }

    public static final class KVVertxStub
    extends AbstractStub<KVVertxStub> {
        private final ContextInternal ctx;
        private KVGrpc.KVStub delegateStub;

        private KVVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = KVGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private KVVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = KVGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        protected KVVertxStub build(Channel channel, CallOptions callOptions) {
            return new KVVertxStub(channel, callOptions);
        }

        public Future<RangeResponse> range(RangeRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::range);
        }

        public Future<PutResponse> put(PutRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::put);
        }

        public Future<DeleteRangeResponse> deleteRange(DeleteRangeRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::deleteRange);
        }

        public Future<TxnResponse> txn(TxnRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::txn);
        }

        public Future<CompactionResponse> compact(CompactionRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::compact);
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final KVVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(KVVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((RangeRequest)request), responseObserver, (String)this.compression, this.serviceImpl::range);
                    break;
                }
                case 1: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((PutRequest)request), responseObserver, (String)this.compression, this.serviceImpl::put);
                    break;
                }
                case 2: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((DeleteRangeRequest)request), responseObserver, (String)this.compression, this.serviceImpl::deleteRange);
                    break;
                }
                case 3: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((TxnRequest)request), responseObserver, (String)this.compression, this.serviceImpl::txn);
                    break;
                }
                case 4: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((CompactionRequest)request), responseObserver, (String)this.compression, this.serviceImpl::compact);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class KVVertxImplBase
    implements BindableService {
        private String compression;

        public KVVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<RangeResponse> range(RangeRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<PutResponse> put(PutRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<DeleteRangeResponse> deleteRange(DeleteRangeRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<TxnResponse> txn(TxnRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<CompactionResponse> compact(CompactionRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)KVGrpc.getServiceDescriptor()).addMethod(KVGrpc.getRangeMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(KVGrpc.getPutMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).addMethod(KVGrpc.getDeleteRangeMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2, this.compression))).addMethod(KVGrpc.getTxnMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3, this.compression))).addMethod(KVGrpc.getCompactMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 4, this.compression))).build();
        }
    }
}

