/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.handler.logging.ByteBufFormat;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBaseConverter;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public abstract class ClientOptionsBase
extends TCPSSLOptions {
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final String DEFAULT_METRICS_NAME = "";
    private int connectTimeout;
    private String metricsName;
    private ProxyOptions proxyOptions;
    private String localAddress;
    private List<String> nonProxyHosts;

    public ClientOptionsBase() {
        this.init();
    }

    public ClientOptionsBase(ClientOptionsBase other) {
        super(other);
        this.connectTimeout = other.getConnectTimeout();
        this.metricsName = other.metricsName;
        this.proxyOptions = other.proxyOptions != null ? new ProxyOptions(other.proxyOptions) : null;
        this.localAddress = other.localAddress;
        this.nonProxyHosts = other.nonProxyHosts != null ? new ArrayList<String>(other.nonProxyHosts) : null;
    }

    public ClientOptionsBase(JsonObject json) {
        super(json);
        this.init();
        ClientOptionsBaseConverter.fromJson(json, this);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        ClientOptionsBaseConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.connectTimeout = 60000;
        this.metricsName = DEFAULT_METRICS_NAME;
        this.proxyOptions = null;
        this.localAddress = null;
    }

    @Override
    @GenIgnore
    public ClientSSLOptions getSslOptions() {
        return (ClientSSLOptions)super.getSslOptions();
    }

    @Override
    protected ClientSSLOptions getOrCreateSSLOptions() {
        return (ClientSSLOptions)super.getOrCreateSSLOptions();
    }

    public boolean isTrustAll() {
        ClientSSLOptions o = this.getSslOptions();
        return o != null ? o.isTrustAll() : false;
    }

    public ClientOptionsBase setTrustAll(boolean trustAll) {
        this.getOrCreateSSLOptions().setTrustAll(trustAll);
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ClientOptionsBase setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public ClientOptionsBase setMetricsName(String metricsName) {
        this.metricsName = metricsName;
        return this;
    }

    public ClientOptionsBase setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public List<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public ClientOptionsBase setNonProxyHosts(List<String> nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
        return this;
    }

    public ClientOptionsBase addNonProxyHost(String host) {
        if (this.nonProxyHosts == null) {
            this.nonProxyHosts = new ArrayList<String>();
        }
        this.nonProxyHosts.add(host);
        return this;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public ClientOptionsBase setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    @Override
    public ClientOptionsBase setLogActivity(boolean logEnabled) {
        return (ClientOptionsBase)super.setLogActivity(logEnabled);
    }

    @Override
    public ClientOptionsBase setActivityLogDataFormat(ByteBufFormat activityLogDataFormat) {
        return (ClientOptionsBase)super.setActivityLogDataFormat(activityLogDataFormat);
    }

    @Override
    public ClientOptionsBase setTcpNoDelay(boolean tcpNoDelay) {
        return (ClientOptionsBase)super.setTcpNoDelay(tcpNoDelay);
    }

    @Override
    public ClientOptionsBase setTcpKeepAlive(boolean tcpKeepAlive) {
        return (ClientOptionsBase)super.setTcpKeepAlive(tcpKeepAlive);
    }

    @Override
    public ClientOptionsBase setSoLinger(int soLinger) {
        return (ClientOptionsBase)super.setSoLinger(soLinger);
    }

    @Override
    public ClientOptionsBase setIdleTimeout(int idleTimeout) {
        return (ClientOptionsBase)super.setIdleTimeout(idleTimeout);
    }

    @Override
    public ClientOptionsBase setReadIdleTimeout(int idleTimeout) {
        return (ClientOptionsBase)super.setReadIdleTimeout(idleTimeout);
    }

    @Override
    public ClientOptionsBase setWriteIdleTimeout(int idleTimeout) {
        return (ClientOptionsBase)super.setWriteIdleTimeout(idleTimeout);
    }

    @Override
    public ClientOptionsBase setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        return (ClientOptionsBase)super.setIdleTimeoutUnit(idleTimeoutUnit);
    }

    @Override
    public ClientOptionsBase setSsl(boolean ssl) {
        return (ClientOptionsBase)super.setSsl(ssl);
    }

    @Override
    public ClientOptionsBase setKeyCertOptions(KeyCertOptions options) {
        return (ClientOptionsBase)super.setKeyCertOptions(options);
    }

    @Override
    public ClientOptionsBase setTrustOptions(TrustOptions options) {
        return (ClientOptionsBase)super.setTrustOptions(options);
    }

    @Override
    public ClientOptionsBase setUseAlpn(boolean useAlpn) {
        return (ClientOptionsBase)super.setUseAlpn(useAlpn);
    }

    @Override
    public ClientOptionsBase setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (ClientOptionsBase)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public ClientOptionsBase setSendBufferSize(int sendBufferSize) {
        return (ClientOptionsBase)super.setSendBufferSize(sendBufferSize);
    }

    @Override
    public ClientOptionsBase setReceiveBufferSize(int receiveBufferSize) {
        return (ClientOptionsBase)super.setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public ClientOptionsBase setReuseAddress(boolean reuseAddress) {
        return (ClientOptionsBase)super.setReuseAddress(reuseAddress);
    }

    @Override
    public ClientOptionsBase setReusePort(boolean reusePort) {
        return (ClientOptionsBase)super.setReusePort(reusePort);
    }

    @Override
    public ClientOptionsBase setTrafficClass(int trafficClass) {
        return (ClientOptionsBase)super.setTrafficClass(trafficClass);
    }

    @Override
    public ClientOptionsBase addEnabledCipherSuite(String suite) {
        return (ClientOptionsBase)super.addEnabledCipherSuite(suite);
    }

    @Override
    public ClientOptionsBase removeEnabledCipherSuite(String suite) {
        return (ClientOptionsBase)super.removeEnabledCipherSuite(suite);
    }

    @Override
    public ClientOptionsBase addCrlPath(String crlPath) throws NullPointerException {
        return (ClientOptionsBase)super.addCrlPath(crlPath);
    }

    @Override
    public ClientOptionsBase addCrlValue(Buffer crlValue) throws NullPointerException {
        return (ClientOptionsBase)super.addCrlValue(crlValue);
    }

    @Override
    public ClientOptionsBase addEnabledSecureTransportProtocol(String protocol) {
        return (ClientOptionsBase)super.addEnabledSecureTransportProtocol(protocol);
    }

    @Override
    public ClientOptionsBase removeEnabledSecureTransportProtocol(String protocol) {
        return (ClientOptionsBase)super.removeEnabledSecureTransportProtocol(protocol);
    }

    @Override
    public ClientOptionsBase setTcpFastOpen(boolean tcpFastOpen) {
        return (ClientOptionsBase)super.setTcpFastOpen(tcpFastOpen);
    }

    @Override
    public ClientOptionsBase setTcpCork(boolean tcpCork) {
        return (ClientOptionsBase)super.setTcpCork(tcpCork);
    }

    @Override
    public ClientOptionsBase setTcpQuickAck(boolean tcpQuickAck) {
        return (ClientOptionsBase)super.setTcpQuickAck(tcpQuickAck);
    }

    @Override
    public ClientOptionsBase setTcpUserTimeout(int tcpUserTimeout) {
        return (ClientOptionsBase)super.setTcpUserTimeout(tcpUserTimeout);
    }
}

