/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.resolver;

import io.netty.channel.EventLoop;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.Address;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.dns.AddressResolverProvider;
import io.vertx.core.spi.endpoint.EndpointBuilder;
import io.vertx.core.spi.endpoint.EndpointResolver;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameResolver
implements io.vertx.core.net.AddressResolver<SocketAddress> {
    private static final Logger log = LoggerFactory.getLogger(NameResolver.class);
    private static final String NDOTS_LABEL = "ndots:";
    private static final String ROTATE_LABEL = "rotate";
    private static final String OPTIONS_ROW_LABEL = "options";
    private static final int DEFAULT_NDOTS = 1;
    private static final boolean DEFAULT_ROTATE = false;
    private final AddressResolverOptions options;
    private final Vertx vertx;
    private final AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final AddressResolverProvider provider;

    public NameResolver(Vertx vertx, AddressResolverOptions options) {
        this.options = options;
        this.provider = AddressResolverProvider.factory(vertx, options);
        this.resolverGroup = this.provider.resolver(options);
        this.vertx = vertx;
    }

    public AddressResolverOptions options() {
        return new AddressResolverOptions(this.options);
    }

    @Override
    public EndpointResolver<SocketAddress, ?, ?, ?> endpointResolver(Vertx vertx) {
        return new Impl();
    }

    public Future<InetAddress> resolve(String hostname) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        io.netty.util.concurrent.Future<InetSocketAddress> fut = this.resolve(context.nettyEventLoop(), hostname);
        PromiseInternal promise = context.promise();
        fut.addListener(promise);
        return promise.map(InetSocketAddress::getAddress);
    }

    public io.netty.util.concurrent.Future<InetSocketAddress> resolve(EventLoop eventLoop, String hostname) {
        AddressResolver<InetSocketAddress> resolver = this.resolver(eventLoop);
        return resolver.resolve(InetSocketAddress.createUnresolved(hostname, 0));
    }

    public void resolveAll(String hostname, Handler<AsyncResult<List<InetSocketAddress>>> resultHandler) {
        ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        io.netty.util.concurrent.Future<List<InetSocketAddress>> fut = this.resolveAll(context.nettyEventLoop(), hostname);
        PromiseInternal promise = context.promise();
        fut.addListener(promise);
        promise.future().onComplete(resultHandler);
    }

    public io.netty.util.concurrent.Future<List<InetSocketAddress>> resolveAll(EventLoop eventLoop, String hostname) {
        AddressResolver<InetSocketAddress> resolver = this.resolver(eventLoop);
        return resolver.resolveAll(InetSocketAddress.createUnresolved(hostname, 0));
    }

    private AddressResolver<InetSocketAddress> resolver(EventLoop eventLoop) {
        return this.resolverGroup.getResolver(eventLoop);
    }

    public AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.resolverGroup;
    }

    public Future<Void> close() {
        return this.provider.close();
    }

    public static ResolverOptions parseLinux(File f) {
        try {
            if (f.exists() && f.isFile()) {
                return NameResolver.parseLinux(new String(Files.readAllBytes(f.toPath())));
            }
        }
        catch (Throwable t) {
            log.debug("Failed to load options from /etc/resolv.conf", t);
        }
        return new ResolverOptions(1, false);
    }

    public static ResolverOptions parseLinux(String input) {
        int ndots = -1;
        boolean rotate = false;
        try {
            int optionsIndex = input.indexOf(OPTIONS_ROW_LABEL);
            if (optionsIndex != -1) {
                boolean isProperOptionsLabel = false;
                if (optionsIndex == 0) {
                    isProperOptionsLabel = true;
                } else if (Character.isWhitespace(input.charAt(optionsIndex - 1))) {
                    isProperOptionsLabel = true;
                }
                if (isProperOptionsLabel) {
                    int ndotsIndex;
                    String afterOptions = input.substring(optionsIndex + OPTIONS_ROW_LABEL.length());
                    int rotateIndex = afterOptions.indexOf(ROTATE_LABEL);
                    if (rotateIndex != -1 && !NameResolver.containsNewLine(afterOptions.substring(0, rotateIndex))) {
                        rotate = true;
                    }
                    if ((ndotsIndex = afterOptions.indexOf(NDOTS_LABEL)) != -1 && !NameResolver.containsNewLine(afterOptions.substring(0, ndotsIndex))) {
                        Matcher matcher = Holder.NDOTS_PATTERN.matcher(afterOptions.substring(ndotsIndex));
                        while (matcher.find()) {
                            ndots = Integer.parseInt(matcher.group(1));
                        }
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            log.debug("Failed to load options from /etc/resolv.conf", e);
        }
        return new ResolverOptions(ndots, rotate);
    }

    private static boolean containsNewLine(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != '\n') continue;
            return true;
        }
        return false;
    }

    private static class Holder {
        private static final Pattern NDOTS_PATTERN = Pattern.compile("ndots:[ \\t\\f]*(\\d)+(?=$|\\s)");

        private Holder() {
        }
    }

    public static class ResolverOptions {
        private final int ndots;
        private final boolean rotate;

        public ResolverOptions(int ndots, boolean rotate) {
            this.ndots = ndots;
            this.rotate = rotate;
        }

        public int ndots() {
            return this.ndots;
        }

        public int effectiveNdots() {
            return this.ndots != -1 ? this.ndots : 1;
        }

        public boolean isRotate() {
            return this.rotate;
        }
    }

    class Impl<L>
    implements EndpointResolver<SocketAddress, SocketAddress, L, L> {
        Impl() {
        }

        @Override
        public SocketAddress tryCast(Address address) {
            return address instanceof SocketAddress ? (SocketAddress)address : null;
        }

        @Override
        public SocketAddress addressOf(SocketAddress server) {
            return server;
        }

        @Override
        public Future<L> resolve(SocketAddress address, EndpointBuilder<L, SocketAddress> builder) {
            Promise promise = Promise.promise();
            NameResolver.this.resolveAll(address.host(), ar -> {
                EndpointBuilder builder2 = builder;
                if (ar.succeeded()) {
                    for (InetSocketAddress addr : (List)ar.result()) {
                        builder2 = builder2.addServer(SocketAddress.inetSocketAddress(address.port(), addr.getAddress().getHostAddress()));
                    }
                    promise.complete(builder2.build());
                } else {
                    promise.fail(ar.cause());
                }
            });
            return promise.future();
        }

        @Override
        public L endpoint(L state) {
            return state;
        }

        @Override
        public boolean isValid(L state) {
            return true;
        }

        @Override
        public void dispose(L data) {
        }

        @Override
        public void close() {
        }
    }
}

