/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.transports;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;

class UnixDomainSocketNioTransport {
    private static final Logger LOG = LoggerFactory.getLogger(UnixDomainSocketNioTransport.class);
    private final Class<?> unixDomainSocketAddressClass;
    private final MethodHandle ofMethodHandle;
    private final MethodHandle getPathMethodHandle;

    private UnixDomainSocketNioTransport(Class<?> unixDomainSocketAddressClass, MethodHandle ofMethodHandle, MethodHandle getPathMethodHandle) {
        this.unixDomainSocketAddressClass = unixDomainSocketAddressClass;
        this.ofMethodHandle = ofMethodHandle;
        this.getPathMethodHandle = getPathMethodHandle;
    }

    static UnixDomainSocketNioTransport load() {
        if (PlatformDependent.javaVersion() >= 16) {
            try {
                Class<?> unixDomainSocketAddressClass = Class.forName("java.net.UnixDomainSocketAddress");
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                MethodHandle ofMethodHandle = lookup.findStatic(unixDomainSocketAddressClass, "of", MethodType.methodType(unixDomainSocketAddressClass, Path.class));
                MethodHandle getPathMethodHandle = lookup.findVirtual(unixDomainSocketAddressClass, "getPath", MethodType.methodType(Path.class));
                return new UnixDomainSocketNioTransport(unixDomainSocketAddressClass, ofMethodHandle, getPathMethodHandle);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                LOG.warn("JDK Unix Domain Socket support is not available", e);
            }
        }
        return null;
    }

    java.net.SocketAddress convert(SocketAddress address) {
        try {
            return this.ofMethodHandle.invoke(Path.of(address.path(), new String[0]));
        }
        catch (Throwable cause) {
            UnixDomainSocketNioTransport.rethrowIfPossible(cause);
            throw new LinkageError("java.net.UnixDomainSocketAddress.of not available", cause);
        }
    }

    boolean isUnixDomainSocketAddress(java.net.SocketAddress address) {
        return this.unixDomainSocketAddressClass.isAssignableFrom(address.getClass());
    }

    SocketAddress convert(java.net.SocketAddress address) {
        try {
            Path path = this.getPathMethodHandle.invoke(address);
            return new SocketAddressImpl(path.toAbsolutePath().toString());
        }
        catch (Throwable cause) {
            UnixDomainSocketNioTransport.rethrowIfPossible(cause);
            throw new LinkageError("java.net.UnixDomainSocketAddress.getPath not available", cause);
        }
    }

    private static void rethrowIfPossible(Throwable cause) {
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
    }
}

