/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.impl.clustered.DefaultNodeSelector;
import io.vertx.core.eventbus.impl.clustered.NodeSelector;
import io.vertx.core.file.impl.FileResolverImpl;
import io.vertx.core.impl.ServiceHelper;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.transports.NioTransport;
import io.vertx.core.internal.VertxBootstrap;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.ExecutorServiceFactory;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxServiceProvider;
import io.vertx.core.spi.VertxThreadFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.context.executor.EventExecutorProvider;
import io.vertx.core.spi.file.FileResolver;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.spi.transport.Transport;
import java.util.Collection;
import java.util.List;

public class VertxBootstrapImpl
implements VertxBootstrap {
    private static final Logger log = LoggerFactory.getLogger(VertxBootstrapImpl.class);
    private VertxOptions options;
    private boolean enableShadowContext;
    private JsonObject config;
    private Transport transport;
    private EventExecutorProvider eventExecutorProvider;
    private ClusterManager clusterManager;
    private NodeSelector clusterNodeSelector;
    private VertxTracerFactory tracerFactory;
    private VertxTracer tracer;
    private VertxThreadFactory threadFactory;
    private ExecutorServiceFactory executorServiceFactory;
    private VertxMetricsFactory metricsFactory;
    private VertxMetrics metrics;
    private FileResolver fileResolver;

    public VertxBootstrapImpl(JsonObject config) {
        this(new VertxOptions(config));
        this.config = config;
        this.enableShadowContext = false;
    }

    public VertxBootstrapImpl(VertxOptions options) {
        this.options = options;
        this.enableShadowContext = false;
    }

    public VertxBootstrapImpl() {
        this(new VertxOptions());
    }

    @Override
    public VertxOptions options() {
        return this.options;
    }

    @Override
    public VertxBootstrap options(VertxOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public VertxBootstrap enableShadowContext(boolean option) {
        this.enableShadowContext = option;
        return this;
    }

    public JsonObject config() {
        return this.config;
    }

    @Override
    public VertxBootstrap eventExecutorProvider(EventExecutorProvider provider) {
        this.eventExecutorProvider = provider;
        return this;
    }

    @Override
    public EventExecutorProvider eventExecutorProvider() {
        return this.eventExecutorProvider;
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    @Override
    public VertxBootstrapImpl transport(Transport transport) {
        this.transport = transport;
        return this;
    }

    @Override
    public ClusterManager clusterManager() {
        return this.clusterManager;
    }

    @Override
    public VertxBootstrapImpl clusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        return this;
    }

    @Override
    public VertxMetricsFactory metricsFactory() {
        return this.metricsFactory;
    }

    @Override
    public VertxBootstrapImpl metricsFactory(VertxMetricsFactory factory) {
        this.metricsFactory = factory;
        return this;
    }

    public NodeSelector clusterNodeSelector() {
        return this.clusterNodeSelector;
    }

    public VertxBootstrapImpl clusterNodeSelector(NodeSelector selector) {
        this.clusterNodeSelector = selector;
        return this;
    }

    @Override
    public VertxTracerFactory tracerFactory() {
        return this.tracerFactory;
    }

    @Override
    public VertxBootstrapImpl tracerFactory(VertxTracerFactory factory) {
        this.tracerFactory = factory;
        return this;
    }

    public VertxTracer tracer() {
        return this.tracer;
    }

    public VertxBootstrapImpl tracer(VertxTracer tracer) {
        this.tracer = tracer;
        return this;
    }

    public VertxMetrics metrics() {
        return this.metrics;
    }

    public VertxBootstrapImpl metrics(VertxMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    @Override
    public FileResolver fileResolver() {
        return this.fileResolver;
    }

    @Override
    public VertxBootstrapImpl fileResolver(FileResolver resolver) {
        this.fileResolver = resolver;
        return this;
    }

    @Override
    public VertxThreadFactory threadFactory() {
        return this.threadFactory;
    }

    @Override
    public VertxBootstrapImpl threadFactory(VertxThreadFactory factory) {
        this.threadFactory = factory;
        return this;
    }

    @Override
    public ExecutorServiceFactory executorServiceFactory() {
        return this.executorServiceFactory;
    }

    @Override
    public VertxBootstrapImpl executorServiceFactory(ExecutorServiceFactory factory) {
        this.executorServiceFactory = factory;
        return this;
    }

    private VertxImpl instantiateVertx(ClusterManager clusterManager, NodeSelector nodeSelector) {
        this.checkBeforeInstantiating();
        Transport tr = this.transport;
        Throwable transportUnavailabilityCause = null;
        if (tr != null) {
            if (!tr.isAvailable()) {
                transportUnavailabilityCause = tr.unavailabilityCause();
                tr = NioTransport.INSTANCE;
            }
        } else {
            tr = NioTransport.INSTANCE;
        }
        return new VertxImpl(this.options, clusterManager, nodeSelector, this.metrics, this.tracer, tr, transportUnavailabilityCause, this.fileResolver, this.threadFactory, this.executorServiceFactory, this.eventExecutorProvider, this.enableShadowContext);
    }

    @Override
    public Vertx vertx() {
        VertxImpl vertx = this.instantiateVertx(null, null);
        vertx.init();
        return vertx;
    }

    @Override
    public Future<Vertx> clusteredVertx() {
        if (this.clusterManager == null) {
            throw new IllegalStateException("No ClusterManagerFactory instances found on classpath");
        }
        NodeSelector nodeSelector = this.clusterNodeSelector;
        if (nodeSelector == null) {
            nodeSelector = new DefaultNodeSelector();
        }
        VertxImpl vertx = this.instantiateVertx(this.clusterManager, nodeSelector);
        return vertx.initClustered(this.options);
    }

    @Override
    public VertxBootstrapImpl init() {
        this.initTransport();
        this.initMetrics();
        this.initTracing();
        List<VertxServiceProvider> providers = ServiceHelper.loadFactories(VertxServiceProvider.class);
        this.initProviders(providers);
        this.initThreadFactory();
        this.initExecutorServiceFactory();
        this.initFileResolver();
        return this;
    }

    private void initProviders(Collection<VertxServiceProvider> providers) {
        for (VertxServiceProvider provider : providers) {
            if (provider instanceof VertxMetricsFactory && (this.options.getMetricsOptions() == null || !this.options.getMetricsOptions().isEnabled()) || provider instanceof VertxTracerFactory && this.options.getTracingOptions() == null) continue;
            provider.init(this);
        }
    }

    private void initMetrics() {
        VertxMetricsFactory provider = this.metricsFactory;
        if (provider != null) {
            provider.init(this);
        }
    }

    private void initTracing() {
        VertxTracerFactory provider = this.tracerFactory;
        if (provider != null) {
            provider.init(this);
        }
    }

    private void initTransport() {
    }

    private void initFileResolver() {
        if (this.fileResolver != null) {
            return;
        }
        this.fileResolver = new FileResolverImpl(this.options.getFileSystemOptions());
    }

    private void initThreadFactory() {
        if (this.threadFactory != null) {
            return;
        }
        this.threadFactory = VertxThreadFactory.INSTANCE;
    }

    private void initExecutorServiceFactory() {
        if (this.executorServiceFactory != null) {
            return;
        }
        this.executorServiceFactory = ExecutorServiceFactory.INSTANCE;
    }

    private void checkBeforeInstantiating() {
        this.checkTracing();
        this.checkMetrics();
    }

    private void checkTracing() {
        if (this.options.getTracingOptions() != null && this.tracer == null) {
            log.warn("Tracing options are configured but no tracer is instantiated. Make sure you have the VertxTracerFactory in your classpath and META-INF/services/io.vertx.core.spi.VertxServiceProvider contains the factory FQCN, or tracingOptions.getFactory() returns a non null value");
        }
    }

    private void checkMetrics() {
        if (this.options.getMetricsOptions() != null && this.options.getMetricsOptions().isEnabled() && this.metrics == null) {
            log.warn("Metrics options are configured but no metrics object is instantiated. Make sure you have the VertxMetricsFactory in your classpath and META-INF/services/io.vertx.core.spi.VertxServiceProvider contains the factory FQCN, or metricsOptions.getFactory() returns a non null value");
        }
    }
}

