/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerStreamHandler;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;

class Http2ServerStream
extends VertxHttp2Stream<Http2ServerConnection> {
    protected final Http2Headers headers;
    protected final String scheme;
    protected final HttpMethod method;
    protected final String uri;
    protected final boolean hasAuthority;
    private final HostAndPort computedAuthority;
    private final HostAndPort realAuthority;
    private final TracingPolicy tracingPolicy;
    private Object metric;
    private Object trace;
    private boolean halfClosedRemote;
    private boolean requestEnded;
    private boolean responseEnded;
    Http2ServerStreamHandler request;

    Http2ServerStream(Http2ServerConnection conn, ContextInternal context, Http2Headers headers, HttpMethod method, String uri, TracingPolicy tracingPolicy, boolean halfClosedRemote) {
        super(conn, context);
        this.headers = headers;
        this.method = method;
        this.uri = uri;
        this.scheme = null;
        this.hasAuthority = false;
        this.computedAuthority = null;
        this.realAuthority = null;
        this.tracingPolicy = tracingPolicy;
        this.halfClosedRemote = halfClosedRemote;
    }

    Http2ServerStream(Http2ServerConnection conn, ContextInternal context, Http2Headers headers, String scheme, boolean hasAuthority, HostAndPort realAuthority, HostAndPort computedAuthority, HttpMethod method, String uri, TracingPolicy tracingPolicy, boolean halfClosedRemote) {
        super(conn, context);
        this.scheme = scheme;
        this.headers = headers;
        this.hasAuthority = hasAuthority;
        this.realAuthority = realAuthority;
        this.computedAuthority = computedAuthority;
        this.uri = uri;
        this.method = method;
        this.tracingPolicy = tracingPolicy;
        this.halfClosedRemote = halfClosedRemote;
    }

    void registerMetrics() {
        HttpServerMetrics metrics;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            this.metric = this.request.response().isPush() ? metrics.responsePushed(((Http2ServerConnection)this.conn).metric(), this.method(), this.uri, this.request.response()) : metrics.requestBegin(((Http2ServerConnection)this.conn).metric(), (HttpRequest)((Object)this.request));
        }
    }

    public HostAndPort authority() {
        return this.computedAuthority;
    }

    public HostAndPort authority(boolean real) {
        return real ? this.realAuthority : this.computedAuthority;
    }

    @Override
    void onHeaders(Http2Headers headers, StreamPriority streamPriority) {
        VertxTracer tracer;
        if (streamPriority != null) {
            this.priority(streamPriority);
        }
        this.registerMetrics();
        CharSequence value = (CharSequence)headers.get(HttpHeaderNames.EXPECT);
        if (((Http2ServerConnection)this.conn).options.isHandle100ContinueAutomatically() && (value != null && HttpHeaderValues.CONTINUE.equals(value) || headers.contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE))) {
            this.request.response().writeContinue();
        }
        if ((tracer = this.context.tracer()) != null) {
            this.trace = tracer.receiveRequest(this.context, SpanKind.RPC, this.tracingPolicy, this.request, this.method().name(), new Http2HeadersAdaptor(headers), HttpUtils.SERVER_REQUEST_TAG_EXTRACTOR);
        }
        this.request.dispatch(((Http2ServerConnection)this.conn).requestHandler);
    }

    @Override
    void onEnd(MultiMap trailers) {
        HttpServerMetrics metrics;
        this.requestEnded = true;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            metrics.requestEnd(this.metric, (HttpRequest)((Object)this.request), this.bytesRead());
        }
        super.onEnd(trailers);
    }

    @Override
    void doWriteHeaders(Http2Headers headers, boolean end, boolean checkFlush, Promise<Void> promise) {
        HttpServerMetrics metrics;
        if (Metrics.METRICS_ENABLED && !end && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            metrics.responseBegin(this.metric, this.request.response());
        }
        super.doWriteHeaders(headers, end, checkFlush, promise);
    }

    @Override
    protected void doWriteReset(long code, Promise<Void> promise) {
        if (!this.requestEnded || !this.responseEnded) {
            super.doWriteReset(code, promise);
        } else {
            promise.fail("Request ended");
        }
    }

    @Override
    void handleWriteQueueDrained() {
        this.request.response().handleWriteQueueDrained();
    }

    public HttpMethod method() {
        return this.method;
    }

    @Override
    protected void endWritten() {
        HttpServerMetrics metrics;
        this.responseEnded = true;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            metrics.responseEnd(this.metric, this.request.response(), this.bytesWritten());
        }
    }

    @Override
    void handleClose() {
        super.handleClose();
        this.request.handleClose();
    }

    @Override
    void handleReset(long errorCode) {
        this.request.handleReset(errorCode);
    }

    @Override
    void handleException(Throwable cause) {
        this.request.handleException(cause);
    }

    @Override
    void handleCustomFrame(HttpFrame frame) {
        this.request.handleCustomFrame(frame);
    }

    @Override
    void handlePriorityChange(StreamPriority newPriority) {
        this.request.handlePriorityChange(newPriority);
    }

    @Override
    void handleData(Buffer buf) {
        this.request.handleData(buf);
    }

    @Override
    void handleEnd(MultiMap trailers) {
        this.halfClosedRemote = true;
        this.request.handleEnd(trailers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onClose() {
        HttpServerMetrics metrics;
        if (!(!Metrics.METRICS_ENABLED || (metrics = ((Http2ServerConnection)this.conn).metrics()) == null || this.requestEnded && this.responseEnded)) {
            metrics.requestReset(this.metric);
        }
        this.request.onClose();
        VertxTracer tracer = this.context.tracer();
        Object trace = this.trace;
        if (tracer != null && trace != null) {
            HttpClosedException failure;
            Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
            synchronized (http2ServerConnection) {
                failure = !this.halfClosedRemote && (!this.requestEnded || !this.responseEnded) ? HttpUtils.STREAM_CLOSED_EXCEPTION : null;
            }
            tracer.sendResponse(this.context, failure == null ? this.request.response() : null, trace, failure, HttpUtils.SERVER_RESPONSE_TAG_EXTRACTOR);
        }
        super.onClose();
    }

    public Object metric() {
        return this.metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void routed(String route) {
        if (Metrics.METRICS_ENABLED) {
            EventLoop eventLoop = this.vertx.getOrCreateContext().nettyEventLoop();
            Http2ServerStream http2ServerStream = this;
            synchronized (http2ServerStream) {
                if (!eventLoop.inEventLoop()) {
                    eventLoop.execute(() -> this.routedInternal(route));
                    return;
                }
            }
            this.routedInternal(route);
        }
    }

    private void routedInternal(String route) {
        HttpServerMetrics metrics = ((Http2ServerConnection)this.conn).metrics();
        if (metrics != null && !this.responseEnded) {
            metrics.requestRouted(this.metric, route);
        }
    }
}

