/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.MimeMapping;
import io.vertx.core.http.impl.CookieJar;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.http.impl.VertxAssembledHttpResponse;
import io.vertx.core.http.impl.VertxFullHttpResponse;
import io.vertx.core.http.impl.VertxHttpContent;
import io.vertx.core.http.impl.VertxHttpObject;
import io.vertx.core.http.impl.VertxHttpResponse;
import io.vertx.core.http.impl.VertxLastHttpContent;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.NetSocket;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.observability.HttpResponse;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Set;

public class Http1xServerResponse
implements HttpServerResponse,
HttpResponse {
    private static final Buffer EMPTY_BUFFER = BufferInternal.buffer(Unpooled.EMPTY_BUFFER);
    private static final String RESPONSE_WRITTEN = "Response has already been written";
    private final VertxInternal vertx;
    private final HttpRequest request;
    private final Http1xServerConnection conn;
    private final ContextInternal context;
    private HttpResponseStatus status;
    private final HttpVersion version;
    private final boolean keepAlive;
    private final boolean head;
    private final Object requestMetric;
    private boolean headWritten;
    private boolean written;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Handler<Void> headersEndHandler;
    private Handler<Void> bodyEndHandler;
    private boolean closed;
    private final HeadersMultiMap headers;
    private CookieJar cookies;
    private MultiMap trailers;
    private io.netty.handler.codec.http.HttpHeaders trailingHeaders = EmptyHttpHeaders.INSTANCE;
    private String statusMessage;
    private long bytesWritten;
    private Future<NetSocket> netSocket;

    Http1xServerResponse(VertxInternal vertx, ContextInternal context, Http1xServerConnection conn, HttpRequest request, Object requestMetric, boolean keepAlive) {
        this.vertx = vertx;
        this.conn = conn;
        this.context = context;
        this.version = request.protocolVersion();
        this.headers = HeadersMultiMap.httpHeaders();
        this.request = request;
        this.status = HttpResponseStatus.OK;
        this.requestMetric = requestMetric;
        this.keepAlive = keepAlive;
        this.head = request.method() == io.netty.handler.codec.http.HttpMethod.HEAD;
    }

    private void checkThread() {
        if (this.conn.strictThreadMode && !this.context.executor().inThread()) {
            throw new IllegalStateException("Only the context thread can write a message");
        }
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public MultiMap trailers() {
        if (this.trailers == null) {
            HeadersMultiMap v = HeadersMultiMap.httpHeaders();
            this.trailers = v;
            this.trailingHeaders = v;
        }
        return this.trailers;
    }

    @Override
    public int statusCode() {
        return this.status.code();
    }

    @Override
    public int getStatusCode() {
        return this.status.code();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.status = this.statusMessage != null ? new HttpResponseStatus(statusCode, this.statusMessage) : HttpResponseStatus.valueOf(statusCode);
        }
        return this;
    }

    @Override
    public String getStatusMessage() {
        return this.status.reasonPhrase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.statusMessage = statusMessage;
            this.status = new HttpResponseStatus(this.status.code(), statusMessage);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse setChunked(boolean chunked) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            if (this.version != HttpVersion.HTTP_1_0) {
                this.headers.set(HttpHeaders.TRANSFER_ENCODING, (CharSequence)(chunked ? "chunked" : null));
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.headers.contains(HttpHeaders.TRANSFER_ENCODING, HttpHeaders.CHUNKED, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse putHeader(String key, String value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.headers.set(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse putHeader(String key, Iterable<String> values) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.headers.set(key, (Iterable)values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse putTrailer(String key, String value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse putTrailer(String key, Iterable<String> values) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(key, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.headers.set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.headers.set(name, (Iterable)values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setWriteQueueMaxSize(int size) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.conn.doSetWriteQueueMaxSize(size);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            return this.conn.writeQueueFull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.drainHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse endHandler(@Nullable Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeHead() {
        this.checkThread();
        PromiseInternal<Void> promise = this.context.promise();
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.headWritten) {
                throw new IllegalStateException();
            }
            if (!this.headers.contains(HttpHeaders.TRANSFER_ENCODING) && !this.headers.contains(HttpHeaders.CONTENT_LENGTH)) {
                throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
            }
            this.prepareHeaders(-1L);
            VertxHttpResponse msg = new VertxHttpResponse(this.head, this.version, this.status, this.headers);
            this.conn.write(msg, promise);
        }
        return promise.future();
    }

    @Override
    public Future<Void> write(Buffer chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(((BufferInternal)chunk).getByteBuf(), promise);
        return promise.future();
    }

    @Override
    public Future<Void> write(String chunk, String enc) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(BufferInternal.buffer(chunk, enc).getByteBuf(), promise);
        return promise.future();
    }

    @Override
    public Future<Void> write(String chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(BufferInternal.buffer(chunk).getByteBuf(), promise);
        return promise.future();
    }

    @Override
    public Future<Void> writeContinue() {
        this.checkThread();
        PromiseInternal<Void> promise = this.context.promise();
        this.conn.write100Continue(promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeEarlyHints(MultiMap headers) {
        HeadersMultiMap headersMultiMap;
        this.checkThread();
        PromiseInternal<Void> promise = this.context.promise();
        if (headers instanceof HeadersMultiMap) {
            headersMultiMap = (HeadersMultiMap)headers;
        } else {
            headersMultiMap = HeadersMultiMap.httpHeaders();
            headersMultiMap.addAll(headers);
        }
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
        }
        this.conn.write103EarlyHints(headersMultiMap, promise);
        return promise.future();
    }

    @Override
    public Future<Void> end(String chunk) {
        return this.end(Buffer.buffer(chunk));
    }

    @Override
    public Future<Void> end(String chunk, String enc) {
        return this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public Future<Void> end(Buffer chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.end(chunk, promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end(Buffer chunk, PromiseInternal<Void> listener) {
        this.checkThread();
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            VertxHttpObject msg;
            if (this.written) {
                throw new IllegalStateException(RESPONSE_WRITTEN);
            }
            this.written = true;
            ByteBuf data = ((BufferInternal)chunk).getByteBuf();
            this.bytesWritten += (long)data.readableBytes();
            if (!this.headWritten) {
                this.prepareHeaders(this.bytesWritten);
                msg = new VertxFullHttpResponse(this.head, this.version, this.status, data, this.headers, this.trailingHeaders);
            } else {
                msg = new VertxLastHttpContent(data, this.trailingHeaders);
            }
            this.conn.write(msg, listener);
            if (this.bodyEndHandler != null) {
                this.bodyEndHandler.handle(null);
            }
            if (!this.closed && this.endHandler != null) {
                this.endHandler.handle(null);
            }
            if (!this.keepAlive) {
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeHandshake() {
        if (this.conn.metrics != null) {
            this.conn.metrics.responseBegin(this.requestMetric, this);
        }
        this.setStatusCode(101);
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.headWritten = true;
            this.written = true;
        }
        this.conn.responseComplete();
    }

    @Override
    public Future<Void> end() {
        return this.end(EMPTY_BUFFER);
    }

    @Override
    public Future<Void> sendFile(String filename, long offset, long length) {
        long size;
        RandomAccessFile raf;
        File file = this.vertx.fileResolver().resolve(filename);
        try {
            raf = new RandomAccessFile(file, "r");
            size = raf.length();
        }
        catch (Exception e) {
            return this.context.failedFuture(e);
        }
        if (!this.headers.contains(HttpHeaders.CONTENT_TYPE)) {
            CharSequence mimeType = MimeMapping.mimeTypeForFilename(filename);
            if (mimeType == null) {
                mimeType = HttpHeaders.APPLICATION_OCTET_STREAM;
            }
            this.headers.set(HttpHeaders.CONTENT_TYPE, mimeType);
        }
        return this.sendFileInternal(offset, length, size, raf, null, true);
    }

    @Override
    public Future<Void> sendFile(RandomAccessFile file, long offset, long length) {
        long size;
        if (!this.headers.contains(HttpHeaders.CONTENT_TYPE)) {
            this.headers.set(HttpHeaders.CONTENT_TYPE, HttpHeaders.APPLICATION_OCTET_STREAM);
        }
        try {
            size = file.length();
        }
        catch (IOException e) {
            return this.context.failedFuture(e);
        }
        return this.sendFileInternal(offset, length, size, file, null, false);
    }

    @Override
    public Future<Void> sendFile(FileChannel channel, long offset, long length) {
        long size;
        if (!this.headers.contains(HttpHeaders.CONTENT_TYPE)) {
            this.headers.set(HttpHeaders.CONTENT_TYPE, HttpHeaders.APPLICATION_OCTET_STREAM);
        }
        try {
            size = channel.size();
        }
        catch (IOException e) {
            return this.context.failedFuture(e);
        }
        return this.sendFileInternal(offset, length, size, null, channel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Future<Void> sendFileInternal(long offset, long length, long size, RandomAccessFile file, FileChannel fileChannel, boolean close) {
        Future ret = null;
        try {
            ContextInternal ctx = this.vertx.getOrCreateContext();
            if (offset < 0L) {
                Future<Void> future2 = ctx.failedFuture("offset : " + offset + " (expected: >= 0)");
                return future2;
            }
            if (length < 0L) {
                Future<Void> future3 = ctx.failedFuture("length : " + length + " (expected: >= 0)");
                return future3;
            }
            long actualLength = Math.min(length, size - offset);
            long actualOffset = Math.min(offset, size);
            if (actualLength < 0L) {
                Future<Void> future4 = ctx.failedFuture("offset : " + offset + " is larger than the requested file length : " + size);
                return future4;
            }
            Object object = this.conn;
            synchronized (object) {
                this.checkValid();
                if (this.headWritten) {
                    throw new IllegalStateException("Head already written");
                }
                this.prepareHeaders(actualLength);
                this.bytesWritten = actualLength;
                this.written = true;
                this.conn.write(new VertxAssembledHttpResponse(this.head, this.version, this.status, this.headers), null);
                FileChannel toSend = fileChannel == null ? file.getChannel() : fileChannel;
                ChannelFuture channelFuture = this.conn.sendFile(toSend, actualOffset, actualLength);
                PromiseInternal promise = this.context.promise();
                ret = promise.future();
                channelFuture.addListener(future -> {
                    if (future.isSuccess()) {
                        Handler<Void> end;
                        Handler<Void> handler;
                        Http1xServerConnection http1xServerConnection = this.conn;
                        synchronized (http1xServerConnection) {
                            handler = this.bodyEndHandler;
                        }
                        if (handler != null) {
                            ctx.emit(handler);
                        }
                        Http1xServerConnection http1xServerConnection2 = this.conn;
                        synchronized (http1xServerConnection2) {
                            end = !this.closed ? this.endHandler : null;
                        }
                        if (null != end) {
                            ctx.emit(end);
                        }
                        this.conn.write(new VertxLastHttpContent(Unpooled.buffer(0), DefaultHttpHeadersFactory.trailersFactory().newHeaders()), promise);
                    } else {
                        promise.fail(future.cause());
                    }
                    if (close) {
                        try {
                            if (file != null) {
                                file.close();
                            } else {
                                fileChannel.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            object = ret;
            return object;
        }
        finally {
            if (ret == null && close) {
                try {
                    if (file != null) {
                        file.close();
                    } else {
                        fileChannel.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ended() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closed() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean headWritten() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.headWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bytesWritten() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.headersEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.bodyEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWriteQueueDrained(Void v) {
        Handler<Void> handler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            handler = this.drainHandler;
        }
        if (handler != null) {
            this.context.dispatch(null, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        if (t instanceof HttpClosedException) {
            this.handleClosed();
        } else {
            Handler<Throwable> handler;
            Http1xServerConnection http1xServerConnection = this.conn;
            synchronized (http1xServerConnection) {
                handler = this.exceptionHandler;
                if (handler == null) {
                    return;
                }
            }
            this.context.dispatch(t, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClosed() {
        Handler<Void> closedHandler;
        Handler<Void> endHandler;
        Handler<Throwable> exceptionHandler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            exceptionHandler = this.written ? null : this.exceptionHandler;
            endHandler = this.written ? null : this.endHandler;
            closedHandler = this.closeHandler;
        }
        if (exceptionHandler != null) {
            this.context.dispatch(HttpUtils.CONNECTION_CLOSED_EXCEPTION, exceptionHandler);
        }
        if (endHandler != null) {
            this.context.dispatch(null, endHandler);
        }
        if (closedHandler != null) {
            this.context.dispatch(null, closedHandler);
        }
    }

    private void checkValid() {
        if (this.written) {
            throw new IllegalStateException(RESPONSE_WRITTEN);
        }
    }

    private void checkHeadWritten() {
        if (this.headWritten) {
            throw new IllegalStateException("Response head already sent");
        }
    }

    private void prepareHeaders(long contentLength) {
        if (this.version == HttpVersion.HTTP_1_0 && this.keepAlive) {
            this.headers.set(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE);
        } else if (this.version == HttpVersion.HTTP_1_1 && !this.keepAlive) {
            this.headers.set(HttpHeaders.CONNECTION, HttpHeaders.CLOSE);
        }
        if (this.head || this.status == HttpResponseStatus.NOT_MODIFIED) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
        } else if (contentLength >= 0L && !this.headers.contains(HttpHeaders.CONTENT_LENGTH) && !this.headers.contains(HttpHeaders.TRANSFER_ENCODING)) {
            this.headers.set(HttpHeaders.CONTENT_LENGTH, (CharSequence)HttpUtils.positiveLongToString(contentLength));
        }
        if (this.headersEndHandler != null) {
            this.headersEndHandler.handle(null);
        }
        if (this.cookies != null) {
            this.setCookies();
        }
        if (Metrics.METRICS_ENABLED) {
            this.reportResponseBegin();
        }
        this.headWritten = true;
    }

    private void setCookies() {
        for (ServerCookie cookie : this.cookies) {
            if (!cookie.isChanged()) continue;
            this.headers.add(HttpHeaders.SET_COOKIE, (CharSequence)cookie.encode());
        }
    }

    private void reportResponseBegin() {
        if (this.conn.metrics != null) {
            this.conn.metrics.responseBegin(this.requestMetric, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http1xServerResponse write(ByteBuf chunk, PromiseInternal<Void> promise) {
        this.checkThread();
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            VertxHttpObject msg;
            if (this.written) {
                throw new IllegalStateException(RESPONSE_WRITTEN);
            }
            if (!(this.headWritten || this.headers.contains(HttpHeaders.TRANSFER_ENCODING) || this.headers.contains(HttpHeaders.CONTENT_LENGTH) || this.version == HttpVersion.HTTP_1_0)) {
                throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
            }
            this.bytesWritten += (long)chunk.readableBytes();
            if (!this.headWritten) {
                this.prepareHeaders(-1L);
                msg = new VertxAssembledHttpResponse(this.head, this.version, this.status, (io.netty.handler.codec.http.HttpHeaders)this.headers, chunk);
            } else {
                msg = new VertxHttpContent(chunk);
            }
            this.conn.write(msg, promise);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<NetSocket> netSocket(HttpMethod requestMethod, MultiMap requestHeaders) {
        this.checkThread();
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.netSocket == null) {
                if (this.headWritten) {
                    return this.context.failedFuture("Response already sent");
                }
                if (!HttpUtils.isConnectOrUpgrade(requestMethod, requestHeaders)) {
                    return this.context.failedFuture("HTTP method must be CONNECT or an HTTP upgrade to upgrade the connection to a TCP socket");
                }
                ChannelPipeline pipeline = this.conn.channel().pipeline();
                WebSocketServerExtensionHandler wsHandler = pipeline.get(WebSocketServerExtensionHandler.class);
                if (wsHandler != null) {
                    pipeline.remove(wsHandler);
                }
                this.status = requestMethod == HttpMethod.CONNECT ? HttpResponseStatus.OK : HttpResponseStatus.SWITCHING_PROTOCOLS;
                this.prepareHeaders(-1L);
                PromiseInternal<Void> upgradePromise = this.context.promise();
                this.conn.write(new VertxAssembledHttpResponse(this.head, this.version, this.status, this.headers), upgradePromise);
                this.written = true;
                PromiseInternal<NetSocket> promise = this.context.promise();
                this.netSocket = promise.future();
                this.conn.netSocket(promise);
            }
        }
        return this.netSocket;
    }

    @Override
    public int streamId() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> reset(long code) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.written) {
                return this.context.failedFuture("Response written");
            }
        }
        this.conn.close();
        return this.context.succeededFuture();
    }

    @Override
    public Future<HttpServerResponse> push(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        return this.context.failedFuture("HTTP/1 does not support response push");
    }

    @Override
    public Future<Void> writeCustomFrame(int type, int flags, Buffer payload) {
        return this.context.failedFuture("HTTP/1 does not support custom frames");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CookieJar cookies() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.cookies == null) {
                String cookieHeader = this.request.headers().get(HttpHeaders.COOKIE);
                this.cookies = cookieHeader == null ? new CookieJar() : new CookieJar(cookieHeader);
            }
        }
        return this.cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.cookies().add((ServerCookie)cookie);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Cookie removeCookie(String name, boolean invalidate) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidate(name, invalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Cookie removeCookie(String name, String domain, String path, boolean invalidate) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidate(name, domain, path, invalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Set<Cookie> removeCookies(String name, boolean invalidate) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidateAll(name, invalidate);
        }
    }
}

