/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import com.google.protobuf.ByteString;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Election;
import io.etcd.jetcd.api.CampaignRequest;
import io.etcd.jetcd.api.LeaderRequest;
import io.etcd.jetcd.api.ProclaimRequest;
import io.etcd.jetcd.api.ResignRequest;
import io.etcd.jetcd.api.VertxElectionGrpc;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.election.CampaignResponse;
import io.etcd.jetcd.election.LeaderKey;
import io.etcd.jetcd.election.LeaderResponse;
import io.etcd.jetcd.election.NoLeaderException;
import io.etcd.jetcd.election.NotLeaderException;
import io.etcd.jetcd.election.ProclaimResponse;
import io.etcd.jetcd.election.ResignResponse;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.impl.Impl;
import io.etcd.jetcd.support.Errors;
import io.etcd.jetcd.support.Util;
import io.grpc.StatusRuntimeException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class ElectionImpl
extends Impl
implements Election {
    private final VertxElectionGrpc.ElectionVertxStub stub;
    private final ByteSequence namespace;

    ElectionImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxElectionGrpc::newVertxStub);
        this.namespace = connectionManager.getNamespace();
    }

    private VertxElectionGrpc.ElectionVertxStub stubWithLeader() {
        return Util.applyRequireLeader(true, this.stub);
    }

    @Override
    public CompletableFuture<CampaignResponse> campaign(ByteSequence electionName, long leaseId, ByteSequence proposal) {
        Objects.requireNonNull(electionName, "election name should not be null");
        Objects.requireNonNull(proposal, "proposal should not be null");
        CampaignRequest request = CampaignRequest.newBuilder().setName(Util.prefixNamespace(electionName, this.namespace)).setValue(ByteString.copyFrom(proposal.getBytes())).setLease(leaseId).build();
        return this.wrapConvertException(this.execute(() -> this.stubWithLeader().campaign(request), CampaignResponse::new, Errors::isRetryableForNoSafeRedoOp));
    }

    @Override
    public CompletableFuture<ProclaimResponse> proclaim(LeaderKey leaderKey, ByteSequence proposal) {
        Objects.requireNonNull(leaderKey, "leader key should not be null");
        Objects.requireNonNull(proposal, "proposal should not be null");
        ProclaimRequest request = ProclaimRequest.newBuilder().setLeader(io.etcd.jetcd.api.LeaderKey.newBuilder().setKey(ByteString.copyFrom(leaderKey.getKey().getBytes())).setName(ByteString.copyFrom(leaderKey.getName().getBytes())).setLease(leaderKey.getLease()).setRev(leaderKey.getRevision()).build()).setValue(ByteString.copyFrom(proposal.getBytes())).build();
        return this.wrapConvertException(this.execute(() -> this.stubWithLeader().proclaim(request), ProclaimResponse::new, Errors::isRetryableForNoSafeRedoOp));
    }

    @Override
    public CompletableFuture<LeaderResponse> leader(ByteSequence electionName) {
        Objects.requireNonNull(electionName, "election name should not be null");
        LeaderRequest request = LeaderRequest.newBuilder().setName(Util.prefixNamespace(electionName, this.namespace)).build();
        return this.wrapConvertException(this.execute(() -> this.stubWithLeader().leader(request), (S response) -> new LeaderResponse((io.etcd.jetcd.api.LeaderResponse)response, this.namespace), Errors::isRetryableForNoSafeRedoOp));
    }

    @Override
    public void observe(ByteSequence electionName, Election.Listener listener) {
        Objects.requireNonNull(electionName, "election name should not be null");
        Objects.requireNonNull(listener, "listener should not be null");
        LeaderRequest request = LeaderRequest.newBuilder().setName(ByteString.copyFrom(electionName.getBytes())).build();
        this.stubWithLeader().observeWithHandler(request, value -> listener.onNext(new LeaderResponse((io.etcd.jetcd.api.LeaderResponse)value, this.namespace)), ignored -> listener.onCompleted(), error -> listener.onError(EtcdExceptionFactory.toEtcdException(error)));
    }

    @Override
    public CompletableFuture<ResignResponse> resign(LeaderKey leaderKey) {
        Objects.requireNonNull(leaderKey, "leader key should not be null");
        ResignRequest request = ResignRequest.newBuilder().setLeader(io.etcd.jetcd.api.LeaderKey.newBuilder().setKey(ByteString.copyFrom(leaderKey.getKey().getBytes())).setName(ByteString.copyFrom(leaderKey.getName().getBytes())).setLease(leaderKey.getLease()).setRev(leaderKey.getRevision()).build()).build();
        return this.wrapConvertException(this.execute(() -> this.stubWithLeader().resign(request), ResignResponse::new, Errors::isRetryableForNoSafeRedoOp));
    }

    private <S> CompletableFuture<S> wrapConvertException(CompletableFuture<S> future) {
        return future.exceptionally(e -> {
            throw this.convertException((Throwable)e);
        });
    }

    private RuntimeException convertException(Throwable e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof StatusRuntimeException)) continue;
            StatusRuntimeException exception = (StatusRuntimeException)cause;
            String description = exception.getStatus().getDescription();
            if ("election: not leader".equals(description)) {
                return new NotLeaderException();
            }
            if (!"election: no leader".equals(description)) continue;
            return new NoLeaderException();
        }
        return EtcdExceptionFactory.toEtcdException(e);
    }
}

