/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.support.Errors;
import io.grpc.Status;
import io.vertx.core.Future;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Impl {
    private final Logger logger;
    private final ClientConnectionManager connectionManager;

    protected Impl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    protected ClientConnectionManager connectionManager() {
        return this.connectionManager;
    }

    protected Logger logger() {
        return this.logger;
    }

    protected <S, T> CompletableFuture<T> completable(Future<S> sourceFuture, Function<S, T> resultConvert) {
        return this.completable(sourceFuture, resultConvert, EtcdExceptionFactory::toEtcdException);
    }

    protected <S, T> CompletableFuture<T> completable(Future<S> sourceFuture, Function<S, T> resultConvert, Function<Throwable, Throwable> exceptionConverter) {
        return this.completable(sourceFuture.compose(r -> Future.succeededFuture(resultConvert.apply(r)), e -> Future.failedFuture((Throwable)exceptionConverter.apply((Throwable)e))));
    }

    protected <S> CompletableFuture<S> completable(Future<S> sourceFuture) {
        return sourceFuture.toCompletionStage().toCompletableFuture();
    }

    protected <S, T> CompletableFuture<T> execute(Supplier<Future<S>> supplier, Function<S, T> resultConvert) {
        return this.execute(supplier, resultConvert, Errors::isRetryable);
    }

    protected <S, T> CompletableFuture<T> execute(Supplier<Future<S>> supplier, Function<S, T> resultConvert, Predicate<Status> doRetry) {
        return Failsafe.with(this.retryPolicy(doRetry), (Policy[])new RetryPolicy[0]).with(this.connectionManager.getExecutorService()).getStageAsync(() -> ((Future)supplier.get()).toCompletionStage()).thenApply(resultConvert);
    }

    protected <S> RetryPolicy<S> retryPolicy(Predicate<Status> doRetry) {
        RetryPolicyBuilder policy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().onFailure(e -> this.logger.warn("retry failure (attempt: {}, error: {})", (Object)e.getAttemptCount(), (Object)(e.getException() != null ? e.getException().getMessage() : "<none>")))).onRetry(e -> this.logger.debug("retry (attempt: {}, error: {})", (Object)e.getAttemptCount(), (Object)(e.getLastException() != null ? e.getLastException().getMessage() : "<none>"))).onRetriesExceeded(e -> this.logger.warn("maximum number of auto retries reached (attempt: {}, error: {})", (Object)e.getAttemptCount(), (Object)(e.getException() != null ? e.getException().getMessage() : "<none>"))).handleIf(throwable -> {
            Status status = Status.fromThrowable(throwable);
            if (Errors.isInvalidTokenError(status)) {
                this.connectionManager.authCredential().refresh();
            }
            if (Errors.isAuthStoreExpired(status)) {
                this.connectionManager.authCredential().refresh();
            }
            return doRetry.test(status);
        })).withMaxRetries(this.connectionManager.builder().retryMaxAttempts()).withBackoff(this.connectionManager.builder().retryDelay(), this.connectionManager.builder().retryMaxDelay(), this.connectionManager.builder().retryChronoUnit());
        if (this.connectionManager.builder().retryMaxDuration() != null) {
            policy = policy.withMaxDuration(this.connectionManager.builder().retryMaxDuration());
        }
        return policy.build();
    }
}

