/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.bridge;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Layout;
import org.apache.log4j.bridge.LayoutWrapper;
import org.apache.log4j.bridge.LogEventAdapter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;

public class LayoutAdapter
implements org.apache.logging.log4j.core.Layout<String> {
    private Layout layout;

    public static org.apache.logging.log4j.core.Layout<?> adapt(Layout layout) {
        if (layout instanceof LayoutWrapper) {
            return ((LayoutWrapper)layout).getLayout();
        }
        if (layout != null) {
            return new LayoutAdapter(layout);
        }
        return null;
    }

    private LayoutAdapter(Layout layout) {
        this.layout = layout;
    }

    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public byte[] getFooter() {
        return this.layout.getFooter() == null ? null : this.layout.getFooter().getBytes();
    }

    @Override
    public byte[] getHeader() {
        return this.layout.getHeader() == null ? null : this.layout.getHeader().getBytes();
    }

    @Override
    public byte[] toByteArray(LogEvent event) {
        String result = this.layout.format(new LogEventAdapter(event));
        return result == null ? null : result.getBytes();
    }

    @Override
    public String toSerializable(LogEvent event) {
        return this.layout.format(new LogEventAdapter(event));
    }

    @Override
    public String getContentType() {
        return this.layout.getContentType();
    }

    @Override
    public Map<String, String> getContentFormat() {
        return new HashMap<String, String>();
    }

    @Override
    public void encode(LogEvent event, ByteBufferDestination destination) {
        byte[] data = this.toByteArray(event);
        destination.writeBytes(data, 0, data.length);
    }
}

