/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.support.Errors;
import io.grpc.Status;
import io.vertx.core.Future;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Impl {
    private final Logger logger;
    private final ClientConnectionManager connectionManager;

    protected Impl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    protected ClientConnectionManager connectionManager() {
        return this.connectionManager;
    }

    protected Logger logger() {
        return this.logger;
    }

    protected <S, T> CompletableFuture<T> completable(Future<S> sourceFuture, Function<S, T> resultConvert) {
        return this.completable(sourceFuture, resultConvert, EtcdExceptionFactory::toEtcdException);
    }

    protected <S, T> CompletableFuture<T> completable(Future<S> sourceFuture, Function<S, T> resultConvert, Function<Throwable, Throwable> exceptionConverter) {
        return this.completable(sourceFuture.compose(r -> Future.succeededFuture(resultConvert.apply(r)), e -> Future.failedFuture((Throwable)exceptionConverter.apply((Throwable)e))));
    }

    protected <S> CompletableFuture<S> completable(Future<S> sourceFuture) {
        return sourceFuture.toCompletionStage().toCompletableFuture();
    }

    protected <S, T> CompletableFuture<T> execute(Supplier<Future<S>> supplier, Function<S, T> resultConvert) {
        return this.execute(supplier, resultConvert, Errors::isRetryable);
    }

    protected <S, T> CompletableFuture<T> execute(Supplier<Future<S>> supplier, Function<S, T> resultConvert, Predicate<Status> doRetry) {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handleIf(throwable -> {
            Status status = Status.fromThrowable(throwable);
            if (Errors.isInvalidTokenError(status)) {
                this.connectionManager.authCredential().refresh();
            }
            return doRetry.test(status);
        })).onRetriesExceeded(e -> this.logger.warn("maximum number of auto retries reached")).withBackoff(this.connectionManager.builder().retryDelay(), this.connectionManager.builder().retryMaxDelay(), this.connectionManager.builder().retryChronoUnit());
        if (this.connectionManager.builder().retryMaxDuration() != null) {
            retryPolicy = retryPolicy.withMaxDuration(this.connectionManager.builder().retryMaxDuration());
        }
        return Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).with(this.connectionManager.getExecutorService()).getStageAsync(() -> ((Future)supplier.get()).toCompletionStage()).thenApply(resultConvert);
    }
}

