/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.options;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.options.OptionsUtil;
import java.util.Optional;

public final class WatchOption {
    public static final WatchOption DEFAULT = WatchOption.newBuilder().build();
    private final Optional<ByteSequence> endKey;
    private final long revision;
    private final boolean prevKV;
    private final boolean progressNotify;
    private final boolean noPut;
    private final boolean noDelete;
    private final boolean requireLeader;

    public static Builder newBuilder() {
        return new Builder();
    }

    private WatchOption(Optional<ByteSequence> endKey, long revision, boolean prevKV, boolean progressNotify, boolean noPut, boolean noDelete, boolean requireLeader) {
        this.endKey = endKey;
        this.revision = revision;
        this.prevKV = prevKV;
        this.progressNotify = progressNotify;
        this.noPut = noPut;
        this.noDelete = noDelete;
        this.requireLeader = requireLeader;
    }

    public Optional<ByteSequence> getEndKey() {
        return this.endKey;
    }

    public long getRevision() {
        return this.revision;
    }

    public boolean isPrevKV() {
        return this.prevKV;
    }

    public boolean isProgressNotify() {
        return this.progressNotify;
    }

    public boolean isNoPut() {
        return this.noPut;
    }

    public boolean isNoDelete() {
        return this.noDelete;
    }

    public boolean withRequireLeader() {
        return this.requireLeader;
    }

    public static class Builder {
        private long revision = 0L;
        private Optional<ByteSequence> endKey = Optional.empty();
        private boolean prevKV = false;
        private boolean progressNotify = false;
        private boolean noPut = false;
        private boolean noDelete = false;
        private boolean requireLeader = false;

        private Builder() {
        }

        public Builder withRevision(long revision) {
            this.revision = revision;
            return this;
        }

        public Builder withRange(ByteSequence endKey) {
            this.endKey = Optional.ofNullable(endKey);
            return this;
        }

        public Builder withPrevKV(boolean prevKV) {
            this.prevKV = prevKV;
            return this;
        }

        public Builder withProgressNotify(boolean progressNotify) {
            this.progressNotify = progressNotify;
            return this;
        }

        public Builder withNoPut(boolean noPut) {
            this.noPut = noPut;
            return this;
        }

        public Builder withNoDelete(boolean noDelete) {
            this.noDelete = noDelete;
            return this;
        }

        public Builder withPrefix(ByteSequence prefix) {
            Preconditions.checkNotNull((Object)prefix, (Object)"prefix should not be null");
            ByteSequence prefixEnd = OptionsUtil.prefixEndOf(prefix);
            this.withRange(prefixEnd);
            return this;
        }

        public Builder withRequireLeader(boolean requireLeader) {
            this.requireLeader = requireLeader;
            return this;
        }

        public WatchOption build() {
            return new WatchOption(this.endKey, this.revision, this.prevKV, this.progressNotify, this.noPut, this.noDelete, this.requireLeader);
        }
    }
}

