/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutionContext {
    volatile Duration startTime = Duration.ZERO;
    volatile Duration attemptStartTime = Duration.ZERO;
    AtomicInteger attempts = new AtomicInteger();
    volatile boolean cancelled;
    volatile Object lastResult;
    volatile Throwable lastFailure;

    ExecutionContext() {
    }

    private ExecutionContext(ExecutionContext context) {
        this.startTime = context.startTime;
        this.attemptStartTime = context.attemptStartTime;
        this.attempts = context.attempts;
        this.cancelled = context.cancelled;
        this.lastResult = context.lastResult;
        this.lastFailure = context.lastFailure;
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos(System.nanoTime() - this.startTime.toNanos());
    }

    public Duration getElapsedAttemptTime() {
        return Duration.ofNanos(System.nanoTime() - this.attemptStartTime.toNanos());
    }

    public int getAttemptCount() {
        return this.attempts.get();
    }

    public <T extends Throwable> T getLastFailure() {
        return (T)this.lastFailure;
    }

    public <T> T getLastResult() {
        return (T)this.lastResult;
    }

    public <T> T getLastResult(T defaultValue) {
        return (T)(this.lastResult != null ? this.lastResult : defaultValue);
    }

    public Duration getStartTime() {
        return this.startTime;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isFirstAttempt() {
        return this.attempts.get() == 0;
    }

    public boolean isRetry() {
        return this.attempts.get() > 0;
    }

    public ExecutionContext copy() {
        return new ExecutionContext(this);
    }

    static ExecutionContext ofResult(Object result) {
        ExecutionContext context = new ExecutionContext();
        context.lastResult = result;
        return context;
    }

    static ExecutionContext ofFailure(Throwable failure) {
        ExecutionContext context = new ExecutionContext();
        context.lastFailure = failure;
        return context;
    }

    public String toString() {
        return "ExecutionContext[attempts=" + this.attempts + ", lastResult=" + this.lastResult + ", lastFailure=" + this.lastFailure + ']';
    }
}

