/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.grpclb;

import io.etcd.jetcd.shaded.com.google.common.base.MoreObjects;
import io.etcd.jetcd.shaded.com.google.common.base.Objects;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbState;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;

final class GrpclbConfig {
    private final GrpclbState.Mode mode;
    @Nullable
    private final String serviceName;

    private GrpclbConfig(GrpclbState.Mode mode, @Nullable String serviceName) {
        this.mode = Preconditions.checkNotNull(mode, "mode");
        this.serviceName = serviceName;
    }

    static GrpclbConfig create(GrpclbState.Mode mode) {
        return GrpclbConfig.create(mode, null);
    }

    static GrpclbConfig create(GrpclbState.Mode mode, @Nullable String serviceName) {
        return new GrpclbConfig(mode, serviceName);
    }

    GrpclbState.Mode getMode() {
        return this.mode;
    }

    @Nullable
    String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpclbConfig that = (GrpclbConfig)o;
        return this.mode == that.mode && Objects.equal(this.serviceName, that.serviceName);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.mode, this.serviceName});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("mode", (Object)this.mode).add("serviceName", this.serviceName).toString();
    }
}

