/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe.util;

import java.util.Objects;

public class Ratio {
    private final int numerator;
    private final int denominator;
    private final double value;

    public Ratio(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.value = denominator == 0 ? 0.0 : (double)numerator / (double)denominator;
    }

    public double getValue() {
        return this.value;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public String toString() {
        return "Ratio[" + this.numerator + " / " + this.denominator + " = " + this.value + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ratio ratio = (Ratio)o;
        return this.numerator == ratio.numerator && this.denominator == ratio.denominator && Double.compare(ratio.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator, this.value);
    }
}

