/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.grpclb;

import io.etcd.jetcd.shaded.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.com.google.common.base.Stopwatch;
import io.etcd.jetcd.shaded.io.grpc.Attributes;
import io.etcd.jetcd.shaded.io.grpc.ChannelLogger;
import io.etcd.jetcd.shaded.io.grpc.ConnectivityStateInfo;
import io.etcd.jetcd.shaded.io.grpc.EquivalentAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancer;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbConfig;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbConstants;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbState;
import io.etcd.jetcd.shaded.io.grpc.grpclb.LbAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.grpclb.SubchannelPool;
import io.etcd.jetcd.shaded.io.grpc.internal.BackoffPolicy;
import io.etcd.jetcd.shaded.io.grpc.internal.TimeProvider;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class GrpclbLoadBalancer
extends LoadBalancer {
    private static final GrpclbConfig DEFAULT_CONFIG = GrpclbConfig.create(GrpclbState.Mode.ROUND_ROBIN);
    private final LoadBalancer.Helper helper;
    private final TimeProvider time;
    private final Stopwatch stopwatch;
    private final SubchannelPool subchannelPool;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private GrpclbConfig config = DEFAULT_CONFIG;
    @Nullable
    private GrpclbState grpclbState;

    GrpclbLoadBalancer(LoadBalancer.Helper helper, SubchannelPool subchannelPool, TimeProvider time, Stopwatch stopwatch, BackoffPolicy.Provider backoffPolicyProvider) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.time = Preconditions.checkNotNull(time, "time provider");
        this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.subchannelPool = Preconditions.checkNotNull(subchannelPool, "subchannelPool");
        this.subchannelPool.init(helper, this);
        this.recreateStates();
        Preconditions.checkNotNull(this.grpclbState, "grpclbState");
    }

    @Override
    @Deprecated
    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        this.grpclbState.handleSubchannelState(subchannel, newState);
    }

    @Override
    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Attributes attributes = resolvedAddresses.getAttributes();
        List<EquivalentAddressGroup> newLbAddresses = attributes.get(GrpclbConstants.ATTR_LB_ADDRS);
        if ((newLbAddresses == null || newLbAddresses.isEmpty()) && resolvedAddresses.getAddresses().isEmpty()) {
            this.handleNameResolutionError(Status.UNAVAILABLE.withDescription("No backend or balancer addresses found"));
            return;
        }
        ArrayList<LbAddressGroup> newLbAddressGroups = new ArrayList();
        if (newLbAddresses != null) {
            for (EquivalentAddressGroup lbAddr : newLbAddresses) {
                String lbAddrAuthority = lbAddr.getAttributes().get(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY);
                if (lbAddrAuthority == null) {
                    throw new AssertionError((Object)("This is a bug: LB address " + lbAddr + " does not have an authority."));
                }
                newLbAddressGroups.add(new LbAddressGroup(lbAddr, lbAddrAuthority));
            }
        }
        newLbAddressGroups = Collections.unmodifiableList(newLbAddressGroups);
        List<EquivalentAddressGroup> newBackendServers = Collections.unmodifiableList(resolvedAddresses.getAddresses());
        GrpclbConfig newConfig = (GrpclbConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (newConfig == null) {
            newConfig = DEFAULT_CONFIG;
        }
        if (!this.config.equals(newConfig)) {
            this.config = newConfig;
            this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Config: " + newConfig);
            this.recreateStates();
        }
        this.grpclbState.handleAddresses(newLbAddressGroups, newBackendServers);
    }

    @Override
    public void requestConnection() {
        if (this.grpclbState != null) {
            this.grpclbState.requestConnection();
        }
    }

    private void resetStates() {
        if (this.grpclbState != null) {
            this.grpclbState.shutdown();
            this.grpclbState = null;
        }
    }

    private void recreateStates() {
        this.resetStates();
        Preconditions.checkState(this.grpclbState == null, "Should've been cleared");
        this.grpclbState = new GrpclbState(this.config, this.helper, this.subchannelPool, this.time, this.stopwatch, this.backoffPolicyProvider);
    }

    @Override
    public void shutdown() {
        this.resetStates();
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.grpclbState != null) {
            this.grpclbState.propagateError(error);
        }
    }

    @Override
    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    @Nullable
    @VisibleForTesting
    GrpclbState getGrpclbState() {
        return this.grpclbState;
    }
}

