/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.options;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.options.OptionsUtil;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import java.util.Optional;

public final class DeleteOption {
    public static final DeleteOption DEFAULT = DeleteOption.newBuilder().build();
    private final Optional<ByteSequence> endKey;
    private final boolean prevKV;

    public static Builder newBuilder() {
        return new Builder();
    }

    private DeleteOption(Optional<ByteSequence> endKey, boolean prevKV) {
        this.endKey = endKey;
        this.prevKV = prevKV;
    }

    public Optional<ByteSequence> getEndKey() {
        return this.endKey;
    }

    public boolean isPrevKV() {
        return this.prevKV;
    }

    public static class Builder {
        private Optional<ByteSequence> endKey = Optional.empty();
        private boolean prevKV = false;

        private Builder() {
        }

        public Builder withRange(ByteSequence endKey) {
            this.endKey = Optional.ofNullable(endKey);
            return this;
        }

        public Builder withPrefix(ByteSequence prefix) {
            Preconditions.checkNotNull(prefix, "prefix should not be null");
            ByteSequence prefixEnd = OptionsUtil.prefixEndOf(prefix);
            this.withRange(prefixEnd);
            return this;
        }

        public Builder withPrevKV(boolean prevKV) {
            this.prevKV = prevKV;
            return this;
        }

        public DeleteOption build() {
            return new DeleteOption(this.endKey, this.prevKV);
        }
    }
}

