/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test;

import io.ebeaninternal.api.SpiLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

final class CaptureLogger
implements SpiLogger {
    private final SpiLogger wrapped;
    private List<String> messages = new ArrayList<String>();
    private boolean active;

    CaptureLogger(SpiLogger wrapped) {
        this.wrapped = wrapped;
    }

    public boolean isDebug() {
        return true;
    }

    public void debug(String msg, Object ... args) {
        if (this.active) {
            if (args != null && args.length > 0) {
                this.messages.add(MessageFormat.format(msg, args));
            } else {
                this.messages.add(msg);
            }
        }
        this.wrapped.debug(msg, args);
    }

    List<String> start() {
        this.active = true;
        return this.collect();
    }

    List<String> stop() {
        this.active = false;
        return this.collect();
    }

    List<String> collect() {
        List<String> response = this.messages;
        this.messages = new ArrayList<String>();
        return response;
    }
}

