/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseDbContainer;
import io.ebean.docker.commands.CockroachConfig;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.container.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CockroachContainer
extends BaseDbContainer
implements Container {
    public static CockroachContainer create(String version, Properties properties) {
        return new CockroachContainer(new CockroachConfig(version, properties));
    }

    public CockroachContainer(CockroachConfig config) {
        super(config);
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return this.execute("database_name", this.showDatabases());
    }

    @Override
    protected boolean isFastStartDatabaseExists() {
        return this.databaseExists();
    }

    @Override
    protected void createDbPreConnectivity() {
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    protected void dropCreateDbPreConnectivity() {
        this.dropDatabaseIfExists();
        this.createDatabase();
    }

    private boolean databaseExists() {
        List<String> outLines = ProcessHandler.process(this.showDatabases()).getOutLines();
        return this.stdoutContains(outLines, this.dbConfig.getDbName());
    }

    protected boolean createDatabase() {
        return this.execute("CREATE DATABASE", this.procCreateDb(), "Failed to create database with owner");
    }

    protected boolean dropDatabaseIfExists() {
        ProcessBuilder pb = this.sqlProcess("drop database if exists " + this.dbConfig.getDbName());
        return this.execute("DROP DATABASE", pb, "Failed to drop database");
    }

    @Override
    public boolean isDatabaseReady() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    private ProcessBuilder procCreateDb() {
        return this.sqlProcess("create database " + this.dbConfig.getDbName());
    }

    private ProcessBuilder showDatabases() {
        return this.sqlProcess("show databases");
    }

    private ProcessBuilder sqlProcess(String sql) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("./cockroach");
        args.add("sql");
        args.add("--insecure");
        args.add("-e");
        args.add(sql);
        return this.createProcessBuilder(args);
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("--hostname=roach1");
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("-p");
        args.add(this.config.getAdminPort() + ":" + this.config.getAdminInternalPort());
        args.add(this.config.getImage());
        args.add("start");
        args.add("--insecure");
        return this.createProcessBuilder(args);
    }
}

