/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import java.util.Properties;

public class NuoDBConfig
extends DbConfig {
    private String network = "nuodb-net";
    private String sm1 = "sm";
    private String te1 = "te";
    private String labels = "node localhost";
    private int port2 = 48004;
    private int internalPort2 = 48004;
    private int port3 = 48005;
    private int internalPort3 = 48005;

    public NuoDBConfig(String version, Properties properties) {
        this(version);
        this.setProperties(properties);
    }

    public NuoDBConfig(String version) {
        super("nuodb", 8888, 8888, version);
        this.containerName = this.platform;
        this.image = "nuodb/nuodb-ce:" + version;
        this.adminUsername = "dba";
        this.adminPassword = "dba";
        this.dbName = "testdb";
    }

    public NuoDBConfig() {
        this("4.0");
    }

    @Override
    public String summary() {
        return "port:" + this.port + " db:" + this.dbName + " schema:" + this.schema + " user:" + this.username + "/" + this.password;
    }

    @Override
    public String jdbcUrl() {
        return "jdbc:com.nuodb://localhost/" + this.getDbName();
    }

    public int getPort2() {
        return this.port2;
    }

    public void setPort2(int port2) {
        this.port2 = port2;
    }

    public int getInternalPort2() {
        return this.internalPort2;
    }

    public void setInternalPort2(int internalPort2) {
        this.internalPort2 = internalPort2;
    }

    public int getPort3() {
        return this.port3;
    }

    public void setPort3(int port3) {
        this.port3 = port3;
    }

    public int getInternalPort3() {
        return this.internalPort3;
    }

    public void setInternalPort3(int internalPort3) {
        this.internalPort3 = internalPort3;
    }

    public String getNetwork() {
        return this.network;
    }

    public NuoDBConfig setNetwork(String network) {
        this.network = network;
        return this;
    }

    public String getSm1() {
        return this.sm1;
    }

    public NuoDBConfig setSm1(String sm1) {
        this.sm1 = sm1;
        return this;
    }

    public String getTe1() {
        return this.te1;
    }

    public NuoDBConfig setTe1(String te1) {
        this.te1 = te1;
        return this;
    }

    public String getLabels() {
        return this.labels;
    }

    public NuoDBConfig setLabels(String labels) {
        this.labels = labels;
        return this;
    }
}

