/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;

final class IOUtils {
    IOUtils() {
    }

    static String readUtf8(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(false);
        try (InputStream is = urlConnection.getInputStream();){
            String string = IOUtils.readUtf8(is);
            return string;
        }
    }

    static String readUtf8(InputStream in) throws IOException {
        return IOUtils.bytesToUtf8(IOUtils.read(in));
    }

    private static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        IOUtils.pump(in, buffer);
        return buffer.toByteArray();
    }

    private static String bytesToUtf8(byte[] data) {
        return new String(data, StandardCharsets.UTF_8);
    }

    private static void pump(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new IOException("Input stream is null");
        }
        if (out == null) {
            throw new IOException("Output stream is null");
        }
        try (OutputStream outputStream = out;
             InputStream inputStream = in;){
            int bytes;
            byte[] buffer = new byte[4096];
            while ((bytes = in.read(buffer)) >= 0) {
                out.write(buffer, 0, bytes);
            }
        }
    }
}

