/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationContext;
import io.ebean.migration.runner.Checksum;
import io.ebean.migration.runner.LocalDdlMigrationResource;
import io.ebean.migration.runner.LocalJdbcMigrationResource;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.LocalUriMigrationResource;
import io.ebean.migration.runner.MigrationMetaRow;
import io.ebean.migration.runner.MigrationPlatform;
import io.ebean.migration.runner.MigrationTable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class FirstCheck {
    final MigrationConfig config;
    final MigrationPlatform platform;
    final MigrationContext context;
    final String schema;
    final String table;
    final String sqlTable;
    boolean tableKnownToExist;
    private int count;

    FirstCheck(MigrationConfig config, MigrationContext context, MigrationPlatform platform) {
        this.config = config;
        this.platform = platform;
        this.context = context;
        this.schema = config.getDbSchema();
        this.table = config.getMetaTable();
        this.sqlTable = this.schema != null ? this.schema + "." + this.table : this.table;
    }

    MigrationTable initTable(boolean checkStateOnly) {
        return new MigrationTable(this, checkStateOnly);
    }

    boolean fastModeCheck(List<LocalMigrationResource> versions) {
        try {
            List<MigrationMetaRow> rows = this.fastRead();
            boolean bl = this.tableKnownToExist = !rows.isEmpty();
            if (rows.size() != versions.size() + 1) {
                return false;
            }
            Map<String, Integer> dbChecksums = FirstCheck.dbChecksumMap(rows);
            for (LocalMigrationResource local : versions) {
                Integer dbChecksum = dbChecksums.get(local.key());
                if (dbChecksum == null) {
                    return false;
                }
                int localChecksum = this.checksumFor(local);
                if (localChecksum == dbChecksum) continue;
                return false;
            }
            this.count = versions.size();
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private static Map<String, Integer> dbChecksumMap(List<MigrationMetaRow> rows) {
        return rows.stream().collect(Collectors.toMap(MigrationMetaRow::version, MigrationMetaRow::checksum));
    }

    private int checksumFor(LocalMigrationResource local) {
        if (local instanceof LocalUriMigrationResource) {
            return ((LocalUriMigrationResource)local).checksum();
        }
        if (local instanceof LocalDdlMigrationResource) {
            return Checksum.calculate(local.content());
        }
        return ((LocalJdbcMigrationResource)local).checksum();
    }

    List<MigrationMetaRow> fastRead() throws SQLException {
        return this.platform.fastReadMigrations(this.sqlTable, this.context.connection());
    }

    int count() {
        return this.count;
    }
}

