/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.pool.Log;
import io.ebean.datasource.pool.PooledConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

final class FreeConnectionBuffer {
    private final LinkedList<PooledConnection> freeBuffer = new LinkedList();

    FreeConnectionBuffer() {
    }

    int size() {
        return this.freeBuffer.size();
    }

    boolean isEmpty() {
        return this.freeBuffer.isEmpty();
    }

    void add(PooledConnection pc) {
        this.freeBuffer.addFirst(pc);
    }

    PooledConnection remove() {
        return this.freeBuffer.removeFirst();
    }

    void closeAll(boolean logErrors) {
        ArrayList<PooledConnection> tempList = new ArrayList<PooledConnection>(this.freeBuffer);
        this.freeBuffer.clear();
        if (Log.isLoggable(System.Logger.Level.TRACE)) {
            Log.trace("... closing all {0} connections from the free list with logErrors: {1}", tempList.size(), logErrors);
        }
        for (PooledConnection connection : tempList) {
            connection.closeConnectionFully(logErrors);
        }
    }

    int trim(long usedSince, long createdSince) {
        int trimCount = 0;
        Iterator iterator = this.freeBuffer.iterator();
        while (iterator.hasNext()) {
            PooledConnection pooledConnection = (PooledConnection)iterator.next();
            if (!pooledConnection.shouldTrim(usedSince, createdSince)) continue;
            iterator.remove();
            pooledConnection.closeConnectionFully(true);
            ++trimCount;
        }
        return trimCount;
    }
}

