/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.pool.ExtendedPreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PstmtCache
extends LinkedHashMap<String, ExtendedPreparedStatement> {
    private static final Logger logger = LoggerFactory.getLogger(PstmtCache.class);
    static final long serialVersionUID = -3096406924865550697L;
    private final int maxSize;
    private int removeCounter;
    private int hitCounter;
    private int missCounter;
    private int putCounter;

    PstmtCache(int maxCacheSize) {
        super(maxCacheSize * 3, 0.75f, true);
        this.maxSize = maxCacheSize;
    }

    String getDescription() {
        return "size[" + this.size() + "] max[" + this.maxSize + "] hits[" + this.hitCounter + "] miss[" + this.missCounter + "] hitRatio[" + this.getHitRatio() + "] removes[" + this.removeCounter + "]";
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    private int getHitRatio() {
        if (this.hitCounter == 0) {
            return 0;
        }
        return this.hitCounter * 100 / (this.hitCounter + this.missCounter);
    }

    public int getHitCounter() {
        return this.hitCounter;
    }

    public int getMissCounter() {
        return this.missCounter;
    }

    public int getPutCounter() {
        return this.putCounter;
    }

    boolean returnStatement(ExtendedPreparedStatement stmt) {
        ExtendedPreparedStatement alreadyInCache = (ExtendedPreparedStatement)super.get(stmt.getCacheKey());
        if (alreadyInCache != null) {
            return false;
        }
        this.put(stmt.getCacheKey(), stmt);
        return true;
    }

    @Override
    public ExtendedPreparedStatement get(Object key) {
        ExtendedPreparedStatement o = (ExtendedPreparedStatement)super.get(key);
        if (o == null) {
            ++this.missCounter;
        } else {
            ++this.hitCounter;
        }
        return o;
    }

    @Override
    public ExtendedPreparedStatement remove(Object key) {
        ExtendedPreparedStatement o = (ExtendedPreparedStatement)super.remove(key);
        if (o == null) {
            ++this.missCounter;
        } else {
            ++this.hitCounter;
        }
        return o;
    }

    @Override
    public ExtendedPreparedStatement put(String key, ExtendedPreparedStatement value) {
        ++this.putCounter;
        return super.put(key, value);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, ExtendedPreparedStatement> eldest) {
        if (this.size() < this.maxSize) {
            return false;
        }
        ++this.removeCounter;
        try {
            ExtendedPreparedStatement stmt = eldest.getValue();
            stmt.closeDestroy();
        }
        catch (SQLException e) {
            logger.error("Error closing ExtendedPreparedStatement", (Throwable)e);
        }
        return true;
    }
}

