/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.util;

import io.ebean.EbeanVersion;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class JdbcClose {
    private static final System.Logger log = EbeanVersion.log;

    public static void close(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error closing statement", (Throwable)e);
        }
    }

    public static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error closing resultSet", (Throwable)e);
        }
    }

    public static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error closing connection", (Throwable)e);
        }
    }

    public static void rollback(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error on connection rollback", (Throwable)e);
        }
    }

    public static void cancel(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.cancel();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error on cancelling statement", (Throwable)e);
        }
    }
}

