/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.meta;

import io.ebean.meta.AbstractMetricVisitor;
import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.MetricData;
import io.ebean.meta.MetricNamingMatch;
import io.ebean.meta.MetricsAsData;
import io.ebean.meta.MetricsAsJson;
import io.ebean.meta.ServerMetrics;
import io.ebean.meta.ServerMetricsAsJson;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class BasicMetricVisitor
extends AbstractMetricVisitor
implements ServerMetrics {
    private final String name;
    private final Function<String, String> naming;
    private final List<MetaTimedMetric> timed = new ArrayList<MetaTimedMetric>();
    private final List<MetaQueryMetric> query = new ArrayList<MetaQueryMetric>();
    private final List<MetaCountMetric> count = new ArrayList<MetaCountMetric>();

    public BasicMetricVisitor() {
        this("db", MetricNamingMatch.INSTANCE);
    }

    public BasicMetricVisitor(String name, Function<String, String> naming) {
        this(name, naming, true, true, true, true);
    }

    public BasicMetricVisitor(String name, Function<String, String> naming, boolean reset, boolean collectTransactionMetrics, boolean collectQueryMetrics, boolean collectL2Metrics) {
        super(reset, collectTransactionMetrics, collectQueryMetrics, collectL2Metrics);
        this.name = name;
        this.naming = naming;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Function<String, String> namingConvention() {
        return this.naming;
    }

    @Override
    public ServerMetricsAsJson asJson() {
        return new MetricsAsJson(this);
    }

    @Override
    public List<MetricData> asData() {
        return new MetricsAsData(this).data();
    }

    @Override
    public List<MetaTimedMetric> timedMetrics() {
        return this.timed;
    }

    @Override
    public List<MetaQueryMetric> queryMetrics() {
        return this.query;
    }

    @Override
    public List<MetaCountMetric> countMetrics() {
        return this.count;
    }

    @Override
    public void visitTimed(MetaTimedMetric metric) {
        this.timed.add(metric);
    }

    @Override
    public void visitQuery(MetaQueryMetric metric) {
        this.query.add(metric);
    }

    @Override
    public void visitCount(MetaCountMetric metric) {
        this.count.add(metric);
    }
}

