/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import io.ebean.config.dbplatform.SqlLimitRequest;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.config.dbplatform.SqlLimiter;

public final class LimitOffsetSqlLimiter
implements SqlLimiter {
    @Override
    public SqlLimitResponse limit(SqlLimitRequest request) {
        int firstRow;
        String dbSql = request.getDbSql();
        StringBuilder sb = new StringBuilder(50 + dbSql.length());
        sb.append("select ");
        if (request.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(dbSql);
        int maxRows = request.getMaxRows();
        if (maxRows > 0) {
            sb.append(" limit ").append(maxRows);
        }
        if ((firstRow = request.getFirstRow()) > 0) {
            sb.append(" offset ").append(firstRow);
        }
        String sql = request.getDbPlatform().completeSql(sb.toString(), request.getOrmQuery());
        return new SqlLimitResponse(sql);
    }
}

